import os
import re

from .openai_utils import chatgpt_chatbot_editing, join_hist


def is_strong_offer_first(price, negotiation):

    return price <= 0.9 * negotiation.buyer_targetPrice


def is_strong_offer_second(price, negotiation):
    return price <= (
        2 * negotiation.buyer_targetPrice - negotiation.current_seller_offer
    )


def is_strong_counteroffer(price, negotiation, debugging=False):
    good_price = (
        negotiation.current_buyer_offer
        + min(negotiation.buyer_reservationPrice, negotiation.current_seller_offer)
    ) / 2
    # answer = price <= min(negotiation.buyer_reservationPrice,(2*negotiation.buyer_targetPrice - negotiation.current_seller_offer))
    answer = price <= good_price
    if debugging:
        print(
            f" Offer (Buyer): {price} ; Previous Offer: {negotiation.current_buyer_offer}; Seller Offer: {negotiation.current_seller_offer} ; Walk Away: {negotiation.buyer_reservationPrice} ; Good Price: {good_price}; Answer: {answer}"
        )

    return answer


def edit_strong_offer_first(history, message, offer, buyer_targetPrice):
    good_price = 0.9 * buyer_targetPrice
    prompt = f""" You are an assistant aimed to reedit text to help a buyer in a negotiation and provide them feedback on their offer.
                
                Here is the conversation : 
                {join_hist(history + [message])}
                The buyer here offered {offer} as a first offer, But given their target price of {buyer_targetPrice}, a strong opening offer should be lower than {good_price}.

                Give them an explanation that their offer should be below ${good_price} given their target price.
                Example of good explanation:

                "Considering your target price of ${buyer_targetPrice}, a strong first offer would ideally be below ${good_price}. This approach helps to keep your target price near the midpoint of the range under discussion."
                """
    edit = chatgpt_chatbot_editing(
        messages=[{"role": "system", "content": prompt}],
    )
    return re.sub(r"Buyer:|Seller:", "", edit)


def edit_strong_offer_second(
    history, message, offer, buyer_targetPrice, seller_currentOffer
):
    good_price = 2 * buyer_targetPrice - seller_currentOffer

    prompt = f""" You are an assistant aimed to reedit text to help a buyer in a negotiation and provide them feedback on their offer.
                
                Here is the conversation :
                {join_hist(history + [message])}
                The buyer here offered {offer} as a first offer, But given their target price of {buyer_targetPrice}, a strong opening offer in that case should be lower than {good_price}.

                Give them an explanation.
                
                Example of good explanation:

                "Considering the seller's offer of ${seller_currentOffer} and your target price of ${buyer_targetPrice}, a strong first offer would ideally be below ${good_price}. This approach helps to keep your target price near the midpoint of the range under discussion." """
    edit = chatgpt_chatbot_editing(
        messages=[
            {"role": "system", "content": prompt},
        ],
    )
    return re.sub(r"Buyer:|Seller:", "", edit)


def edit_strong_counteroffer(
    history, message, offer, previous_offer, buyer_reservationPrice, seller_currentOffer
):
    good_price = (previous_offer + min(buyer_reservationPrice, seller_currentOffer)) / 2

    prompt = f""" You are an assistant aimed to reedit text to help a buyer in a negotiation and provide them feedback on their offer.
                Here is the conversation : 
                {join_hist(history + [message])}
                
                The seller offered {seller_currentOffer}. The buyer here offered {offer} as a counter-offer, But given their previous offer of {previous_offer}, a strong counter offer in that case should be lower than ${good_price}.

                Give them an explanation that given the seller's offer and their target offer, their offer should be below {good_price} to balance the surplus and keep their target price in the middle of it.
                
                Example of good explanation:

                "Don’t 'cave in' immediately. Considering the seller\'s offer of $14,500 and your previous offer of ${seller_currentOffer}, a strong counteroffer would ideally be below ${good_price}. This approach helps to keep your target price near the midpoint of the range under discussion." """

    edit = chatgpt_chatbot_editing(
        messages=[
            {"role": "system", "content": prompt},
        ],
    )
    return re.sub(r"Buyer:|Seller:", "", edit)
