###  Code for submission at EMNLP 2024
## The paper propose and study problem of task and language incremental continual learning, where a multilingual model is updated to accommodate new tasks in previously learned languages or new language for established task

## :wrench: Installation
Our implementation is based on PyTorch and HuggingFace (transformers + datasets).


### 2) install the required packages
Make sure that you have Anaconda installed. If not - follow this [miniconda installation](https://docs.conda.io/en/latest/miniconda.html).

To run code on GPU, make sure that you have a CUDA capable GPU and the [drivers](https://www.nvidia.com/download/index.aspx?lang=en-us) for your GPU are up to date. In our implementation, we used and CUDA 11.0.

You can re-create our conda enviroment from ```requirements.yaml``` file:

```bash
conda env create -f requirements.yaml
```

Your conda should start downloading and extracting packages. This can take ~15-20 minutes.

### 3) Activate the environment:

Your environment should be called ```new_transformers_torch```, and you can activate it now to run the scripts:

```bash
conda activate new_transformers_torch
```

## download data and place in home folder, there is a path for root data dir in each training script.

## :zap: How to run 

```
cd scripts
```
this folder contains trainig scripts for exiting continual learning methods

## Taks and Language Specific Adapters

```
cd TLSA
```
TLSA contains all the code required to train a continual learning model using Task and language 

To train any methods from TLSA

```
cd ./TLSA/script
source <script_name>.sh <GPU ID> <PORT NO> <SEQ>

```

for each method we use thre gpus at ones, port no is needed as if you try to run multiple experiments in parallel, `accelerate` will try to redirect all processes to same port, which will return an error. here SEQ, denotes task

to run other exiting continual learnin experiment:

From main folder
```
cd scripts
bash <method_name>.sh <GPU ID> <PORT NO> <SEQ>
```

you can modify the hyperparameters in training scrip or in `main.py` and `multitask_training.py` for multitask training. 

