# Dataset description

The dataset is contained in the train.json, val.json, and test.json files.

Each record contains the following items: 

- *URL* : URL leading to the original fact-checking article
- *image path* : local path to the image to verify
- *org* : fact-checking organization from which the data was collected
- *publication date* : publication date of the fact-checking article
- *claim* : claim verified in the fact-checking article
- *was the photo used before?* : answer to the Provenance pillar. Yes, No, or Unknown
- *source* : answer to the Source pillar
- *date* : answer to the Date pillar
- *date numeric label* : answer to the Date pillar in numeric format
- *location* : answer to the Location pillar
- *motivation* : answer to the Motivation pillar

The following items are provided as metadata for analysis purpose
- *type of image* : the type of image being verified. True, Out-of-Context, Manipulated, or Fake
- *verification strategy* : the strategy used by fact-checkers to verify the image
- *verification tool* : the list of tools used by fact-checkers to verify the image
- *claimed location* : the location of the image, according to the claim
- *claimed date* : the date of the image, according to the claim