import torch

test_emb = torch.load('/afs//Private/LoRA-P-new/news_headline/outputs/user_100_history_emb.pt')

user_emb = []
for user in test_emb:
    user_emb.append(user['profile_embeddings'].mean(dim=0, keepdim=True))

user_emb = torch.cat(user_emb, dim=0)
x_normalized = torch.nn.functional.normalize(user_emb, p=2, dim=1)

scores = torch.matmul(x_normalized, x_normalized.transpose(0, 1))
scores = (scores - scores.min()) / (scores.max() - scores.min())

torch.save(scores, './outputs/news_headline_user_emb_similarity.pt')