theory question_91_1

imports Main

begin

typedecl entity

consts
  Choices :: "entity ⇒ bool"
  Ship :: "entity ⇒ bool"
  Airplane :: "entity ⇒ bool"
  Move :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  From :: "event ⇒ entity ⇒ bool"
  To :: "event ⇒ entity ⇒ bool"

(* Explanation: Moving entities from one location to another *)
axiomatization where
  explanation: "∀e x y. Move e ⟶ (∃z. Agent e z ∧ Patient e x ∧ From e y ∧ To e z)"

theorem hypothesis:
  (* Premise: You need to move products across the ocean from Boston to Europe. *)
  assumes asm: "Move e ∧ Agent e you ∧ Patient e products ∧ From e Boston ∧ To e Europe"
  (* Hypothesis: The choices are ship or airplane. *)
  shows "∃x. Choices x ∧  Ship x ∨ Airplane x "
proof -
  from asm have "∃z. Agent e z ∧ Patient e products ∧ From e Boston ∧ To e z" using explanation by blast
  then obtain z where z: "Agent e z ∧ Patient e products ∧ From e Boston ∧ To e z" by auto
  then have "Ship z ∨ Airplane z"
    by (rule exI[of _ "`z`"], auto simp: Choices_def Ship_def Airplane_def)
  then show "∃x. Choices x ∧ Ship x ∨ Airplane x" using z by blast
qed

end
