theory question_36_5
imports Main

begin

typedecl entity
typedecl event

consts
  Antigens :: "entity ⇒ bool"
  Substance :: "entity ⇒ bool"
  Protein :: "entity ⇒ bool"
  Surface :: "entity ⇒ bool"
  CancerCells :: "entity ⇒ bool"
  TransplantedOrganCells :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ entity ⇒ bool"
  RecognizedBy :: "event ⇒ entity ⇒ bool"
  FoundOn :: "entity ⇒ entity ⇒ bool"
  Recognition :: "event ⇒ entity ⇒ bool"

(* Explanation 1: Antigens (a) are substances (s), usually proteins (p), on the surface (sur) of cancer cells (c) and transplanted organ cells (o), that can be recognized by the immune system (is) during the recognition event (re). *)
axiomatization where
  explanation_1: "∀a s c o re. Antigens a ⟶ (Substance s ∧ Protein p ∧ Surface sur ∧ CancerCells c ∧ TransplantedOrganCells o ∧ On sur c a ∧ On sur o a ∧ Recognition re a ∧ RecognizedBy re is)"

(* Hypothesis: Antigens (a) are found on cancer cells (c) and transplanted kidney cells (k). *)
theorem hypothesis:
  assumes asm: "Antigens a ∧ CancerCells c ∧ TransplantedOrganCells k"
  shows "FoundOn a c ∧ FoundOn a k"
proof -
  from asm have "Antigens a ∧ On sur c a ∧ On sur k a" using explanation_1 explanation_3 by blast
  then have "FoundOn a c ∧ FoundOn a k" by simp
  show ?thesis using asm this by blast
qed

end
