theory question_54_6
imports Main

begin

typedecl entity
typedecl event

consts
  PlayingTennis :: "event ⇒ bool"
  TennisBall :: "entity ⇒ bool"
  Playing :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Man :: "entity ⇒ bool"
  Red :: "entity ⇒ bool"
  Black :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  AboutToStrike :: "entity ⇒ event ⇒ bool" (* Changed 'event' operand here *)

(* Explanation: A man in red and black about to strike a tennis ball is playing tennis. *)
axiomatization where
  explanation_1: "∀x y z e. Man x ∧ Red y ∧ Black z ∧ Wearing x y ∧ Wearing x z ∧ TennisBall e ∧ AboutToStrike x e ⟶ (∃e. Playing e ∧ Agent e x ∧ PlayingTennis e)"

theorem hypothesis:
  (* Premise: A man in red and black about to strike a tennis ball. *)
  assumes asm: "Man x ∧ Red y ∧ Black z ∧ Wearing x y ∧ Wearing x z ∧ TennisBall e ∧ AboutToStrike x e"
  (* Hypothesis: A man is playing tennis. *)
  shows "∃x e. Man x ∧ Playing e ∧ Agent e x ∧ PlayingTennis e"
proof -
  from asm have "Man x" by auto
  from asm have "TennisBall e" by auto
  from asm have "AboutToStrike x e" by auto
  then have "∃e. Playing e ∧ Agent e x ∧ PlayingTennis e" using explanation_2 by blast
  then show ?thesis by blast
qed

end
