theory question_17_4

imports Main

begin

typedecl entity

consts
  Football_Player :: "entity ⇒ bool"
  Wearing :: "entity ⇒ entity ⇒ bool"
  Orange_Jersey :: "entity ⇒ bool"
  White_Jersey :: "entity ⇒ bool"
  At :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: For all x, if a football player is wearing an orange/white jersey, then they are wearing a jersey. *)
axiomatization where
  explanation_1: "∀x. Football_Player x ∧ (Orange_Jersey x ∨ White_Jersey x) ⟶ Wearing x x"

(* Explanation 2: For the football player, if they are wearing an orange jersey, then they are not wearing a white jersey. *)
axiomatization where
  explanation_2: "∀x. Football_Player x ∧ Orange_Jersey x ⟶ ¬ White_Jersey x"

theorem hypothesis:
  (* Premise: There exist two football players, one wearing an orange jersey and the other wearing a white jersey, who are at the starting line. *)
  assumes asm: "Football_Player x ∧ Football_Player y ∧ Orange_Jersey x ∧ White_Jersey y ∧ At x starting_line ∧ At y starting_line"
  (* Hypothesis: There exist two football players who are wearing a jersey. *)
  shows "∃x y. Football_Player x ∧ Football_Player y ∧ Wearing x x ∧ Wearing y y"
proof -
  from asm have "Football_Player x ∧ Orange_Jersey x ∧ At x starting_line" by blast
  then have "Football_Player x ∧ Wearing x x" using explanation_1 by blast

  from asm have "Football_Player y ∧ White_Jersey y ∧ At y starting_line" by blast
  then have "Football_Player y ∧ Wearing y y" using explanation_1 by blast

  show ?thesis using `Football_Player x` `Wearing x x` `Football_Player y` `Wearing y y` by blast
qed

end
