theory question_65_2

imports Main

begin

typedecl entity
typedecl event

consts
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Switch :: "entity ⇒ bool"
  Components :: "entity ⇒ bool"
  Closed :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Electricity :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  TurnsOn :: "event ⇒ bool"
  ComesOn :: "event ⇒ bool"

(* Explanation 1: In a simple series circuit, when the switch is closed, electricity flows to all components in the circuit. *)
axiomatization where
  explanation_1: "∀x y z e1 e2. SimpleSeriesCircuit x ∧ Switch y ∧ Components z ∧ Closed e1 ∧ Agent e1 y ∧ Flows e2 ∧ Agent e2 x ∧ Patient e2 z"

(* Explanation 2: When electricity flows to a light bulb, the light bulb turns on and comes on. *)
axiomatization where
  explanation_2: "∀x y e1 e2 e3. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (TurnsOn e2 ∧ Agent e2 y) ∧ ComesOn e3 ∧ Agent e3 y"

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "SimpleSeriesCircuit x ∧ Switch y ∧ Closed e"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e1 e2. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ComesOn e2 ∧ Agent e2 y"
proof -
  {
    assume asm: "SimpleSeriesCircuit x ∧ Switch y ∧ Closed e"
    from explanation_1[OF asm]
    obtain z e1 where "Components z ∧ Flows e1 ∧ Agent e1 y ∧ Patient e1 z" by blast
    then obtain e2 where "Electricity x ∧ Agent e2 x ∧ Patient e2 z" by blast
    from explanation_2[OF this, OF ‹LightBulb y›]
    obtain e3 where "ComesOn e3 ∧ Agent e3 y" by blast
    with ‹Electricity x ∧ Agent e2 x ∧ Patient e2 z› have "Electricity x ∧ LightBulb y ∧ Flows e2 ∧ Agent e2 x ∧ Patient e2 y ∧ ComesOn e3 ∧ Agent e3 y" by blast
  }
  thus ?thesis by blast
qed

end
