theory question_23_6

imports Main

begin

typedecl entity
typedecl event

consts
  Hurricane :: "entity ⇒ bool"
  Tornadoes :: "entity ⇒ bool"
  HighWindSpeeds :: "entity ⇒ bool"
  HighWinds :: "event ⇒ bool"
  Have :: "entity ⇒ event ⇒ bool"

(* Explanation 1: A hurricane is an entity with high wind speeds. *)
axiomatization where
  explanation_1: "∀x. Hurricane x ⟶ HighWindSpeeds x"

(* Explanation 2: A tornado is an entity with high wind speeds. *)
axiomatization where
  explanation_2: "∀x. Tornadoes x ⟶ HighWindSpeeds x"

theorem hypothesis:
  assumes asm: "Hurricane x ∨ Tornadoes x"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃e. HighWinds e ∧ Have x e"
proof -
  assume asm: "Hurricane x ∨ Tornadoes x"
  {
    assume "Hurricane x"
    then have "HighWindSpeeds x" by (rule explanation_1)
    then obtain e where "HighWinds e ∧ Have x e" by blast
  }
  moreover {
    assume "Tornadoes x"
    then have "HighWindSpeeds x" by (rule explanation_2)
    then obtain e where "HighWinds e ∧ Have x e" by blast
  }
  ultimately show "∃e. HighWinds e ∧ Have x e" by blast
qed

end
