theory question_81_5

imports Main

begin

typedecl entity
typedecl event

consts
  ExternalMigration :: "entity ⇒ bool"
  Entity :: "entity ⇒ bool"
  SuddenReduction :: "event ⇒ bool"
  PopulationSize :: "event ⇒ entity ⇒ bool"
  Cause :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ event ⇒ bool"
  BottleneckEffect :: "event ⇒ bool"
  Occur :: "event ⇒ bool"
  Occurs :: "event ⇒ bool"
  Result :: "event ⇒ event ⇒ bool"

(* Explanation 1: External migration can cause a sudden reduction in the population size of a specific entity. *)
axiomatization where
  explanation_1: "∀x y e1 e2. ExternalMigration x ∧ Entity y ∧ SuddenReduction e1 ∧ PopulationSize e1 y ⟶ (∃e2. Cause e2 ∧ Agent e2 x ∧ Patient e2 e1)"

(* Explanation 2: A sudden reduction in the population size of a specific entity is a necessary and sufficient condition for the bottleneck effect to occur in that entity. *)
axiomatization where
  explanation_2: "∀x y e1 e2. Entity x ∧ SuddenReduction e1 ∧ PopulationSize e1 x ⟷ (∃e2. BottleneckEffect e2 ∧ Occur e2 ∧ Agent e2 x)"

(* Explanation 3: The bottleneck effect is an event that occurs as a result of a sudden reduction in the population size of a specific entity. *)
axiomatization where
  explanation_3: "∀x y e1 e2. Entity x ∧ SuddenReduction e1 ∧ PopulationSize e1 x ⟶ (∃e2. BottleneckEffect e2 ∧ Occurs e2 ∧ Result e2 e1)"

theorem hypothesis:
  assumes asm: "ExternalMigration x"
  (* Hypothesis: Bottleneck effect can occur with external migration. *)
  shows "∃e. BottleneckEffect e ∧ Occur e ∧ Agent e x"
proof -
  from asm have "ExternalMigration x" by simp
  then obtain e1 where e1: "Entity y ∧ SuddenReduction e1 ∧ PopulationSize e1 y"
    using explanation_1 by blast
  then have "BottleneckEffect e2 ∧ Occur e2 ∧ Agent e2 x"
    using explanation_2 by blast
  show ?thesis using e1 by blast
qed

end
