theory question_63_2

imports Main

begin

typedecl entity
typedecl event

consts
  Rocks :: "entity ⇒ bool"
  Deposition :: "event ⇒ bool"
  FormedBy :: "entity ⇒ event ⇒ bool"
  Sandstone :: "entity ⇒ bool"
  SedimentaryRocks :: "entity ⇒ bool"

(* Explanation 1: Sedimentary rocks are formed exclusively by deposition. *)
axiomatization where
  explanation_1: "∀x e. SedimentaryRocks x ∧ Deposition e ⟷ (∃e. FormedBy x e)"

(* Explanation 2: Sandstone is a common type of sedimentary rock that is formed by deposition. *)
axiomatization where
  explanation_2: "∀x e. Sandstone x ∧ SedimentaryRocks x ∧ Deposition e ⟶ (∃e. FormedBy x e)"

(* Explanation 3: All sedimentary rocks formed by the same deposition event are of the same type. *)
axiomatization where
  explanation_3: "∀x y e. SedimentaryRocks x ∧ SedimentaryRocks y ∧ Deposition e ∧ FormedBy x e ∧ FormedBy y e ⟶ (x = y)"

theorem hypothesis:
  assumes asm: "Rocks x ∧ Deposition e ∧ FormedBy x e"
  (* Hypothesis: Rocks formed by deposition are sandstone. *)
  shows "Sandstone x"
proof -
  from asm have "Rocks x" by simp
  from asm have "Deposition e" by simp
  from asm have "FormedBy x e" by simp
  then have "SedimentaryRocks x" using explanation_1 by blast
  then have "Sandstone x ∧ SedimentaryRocks x ∧ Deposition e" using explanation_2 by blast
  then have "Sandstone x" by simp
  then show ?thesis by simp
qed

end
