theory question_17_7
imports Main

begin

typedecl entity
typedecl event

consts
  Omnivores :: "entity ⇒ bool"
  Feed :: "event ⇒ bool"
  Plants :: "entity ⇒ bool"
  TrophicLevel :: "entity ⇒ bool"
  Producer :: "entity ⇒ bool"
  FirstTrophicLevel :: "entity ⇒ bool"
  Consumers :: "entity ⇒ bool"
  HigherThan :: "entity ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  DifferentTrophicLevels :: "entity ⇒ entity ⇒ bool"

(* Explanation 1: Omnivores feed on plants, which are producers at the first trophic level. *)
axiomatization where
  explanation_1: "∀x e p t. Omnivores x ∧ Feed e ∧ Plants p ∧ TrophicLevel t ∧ Producer p ∧ FirstTrophicLevel t ∧ Agent e x ∧ Patient e p ∧ Patient e t"

(* Explanation 2: Omnivores also feed on consumers that are at various trophic levels higher than the first. *)
axiomatization where
  explanation_2: "∀x e c t1 t2. Omnivores x ∧ Feed e ∧ Consumers c ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ HigherThan t1 t2 ∧ FirstTrophicLevel t1 ∧ Agent e x ∧ Patient e c ∧ Patient e t1 ∧ Patient e t2"

(* Explanation 3: Omnivores feed at multiple trophic levels, specifically the first and higher levels. *)
axiomatization where
  explanation_3: "∀x e t1 t2. Omnivores x ∧ Feed e ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ FirstTrophicLevel t1 ∧ HigherThan t2 t1 ∧ Agent e x ∧ Patient e t1 ∧ Patient e t2"

(* Definition for DifferentTrophicLevels *)
definition DifferentTrophicLevels_def :: "entity ⇒ entity ⇒ bool" where
  "DifferentTrophicLevels_def t1 t2 ≡ t1 ≠ t2 ∧ TrophicLevel t1 ∧ TrophicLevel t2"

(* Hypothesis: Omnivores can feed at more than one trophic level. *)
theorem hypothesis:
  assumes asm: "Omnivores x ∧ Feed e1 ∧ Feed e2 ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ Agent e1 x ∧ Agent e2 x ∧ Patient e1 t1 ∧ Patient e2 t2"
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "∃t1 t2. DifferentTrophicLevels t1 t2 ∧ Agent e1 x ∧ Agent e2 x ∧ Patient e1 t1 ∧ Patient e2 t2"
proof -
  {
    assume "Omnivores x" and "Feed e1" and "Feed e2" and "TrophicLevel t1" and "TrophicLevel t2"
      and "Agent e1 x" and "Agent e2 x" and "Patient e1 t1" and "Patient e2 t2"
    then have "TrophicLevel t1" and "TrophicLevel t2" by simp+
    then have "FirstTrophicLevel t1 ∨ HigherThan t1 t2"
      using explanation_3 by blast
    then have "FirstTrophicLevel t1 ∨ HigherThan t2 t1"
      by (metis HigherThan_commute)
    then have "Plants p ∧ Producer p ∧ FirstTrophicLevel t1 ∧ Agent e1 x ∧ Patient e1 p ∧ Patient e1 t1"
      using explanation_1 by blast
    then have "Plants p ∧ Producer p ∧ Agent e1 x ∧ Patient e1 p ∧ Patient e1 t1" by simp
    then have "Plants p ∧ Producer p ∧ Agent e1 x ∧ Patient e1 p" by simp
    then have "Consumers c ∧ Consumers c ∧ HigherThan t1 t2 ∧ Agent e2 x ∧ Patient e2 c ∧ Patient e2 t1 ∧ Patient e2 t2"
      using explanation_2 by blast
    then have "Consumers c ∧ HigherThan t1 t2 ∧ Agent e2 x ∧ Patient e2 c ∧ Patient e2 t1" by simp
    then have "t1 ≠ t2" using DifferentTrophicLevels_def by blast
    then have "DifferentTrophicLevels t1 t2" using DifferentTrophicLevels_def by blast
    then have "DifferentTrophicLevels t1 t2 ∧ Agent e1 x ∧ Agent e2 x ∧ Patient e1 t1 ∧ Patient e2 t2" by simp
  }
  then show ?thesis using asm by blast
qed

end
