theory question_27_4

imports Main

begin
typedecl entity
typedecl event

consts
  Sidewalk :: "entity ⇒ bool"
  Outdoors :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  OldMan :: "entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Dirty :: "entity ⇒ bool"

(* Explanation 1: Sidewalks are found outdoors. *)
axiomatization where
  explanation_1: "∀x. Sidewalk x ⟶ Outdoors x"

(* Explanation 2: If an entity is on an outdoor entity, then the entity is outside. *)
axiomatization where
  explanation_2: "∀x y. On x y ∧ Outdoors y ⟶ Outside x"

theorem hypothesis:
  (* Premise: A old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "OldMan x ∧ HardwareParts y ∧ Sidewalk z ∧ Dirty z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ On x z"
  (* Hypothesis: The man is outside. *)
  shows "∃x. Man x ∧ Outside x"
proof -
  {
    assume "OldMan x ∧ HardwareParts y ∧ Sidewalk z ∧ Dirty z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ On x z"
    then have "Sidewalk z" by blast
    then have "Outdoors z" using explanation_1 by blast
    then have "On x z ∧ Outdoors z" by blast
    then have "Outside x" using explanation_2 by blast
    then have "Man x ∧ Outside x" using asm by blast
  }
  then show ?thesis by blast
qed

end
