theory question_80_6

imports Main

begin

typedecl entity
typedecl event

consts
  Material :: "entity ⇒ bool"
  ElectricalConductor :: "entity ⇒ bool"
  Copper :: "entity ⇒ bool"

(* Explanation 1: Some materials are electrical conductors. *)
axiomatization where
  explanation_1: "∃x. Material x ∧ ElectricalConductor x"

(* Explanation 2: Copper is an electrical conductor. *)
axiomatization where
  explanation_2: "∀x. Copper x ∧ ElectricalConductor x"

theorem hypothesis:
  (* Premise: Some materials are electrical conductors. *)
  assumes asm: "Material x ∧ ElectricalConductor x"
  (* Hypothesis: Copper is the material that conducts electricity. *)
  shows "∃x. Copper x ∧ ConductsElectricity x"
proof -
  from asm have "Material x ∧ ElectricalConductor x" by simp
  then obtain e1 where e1: "Copper x ∧ ElectricalConductor x" using explanation_2 by blast
  then show ?thesis using e1 by simp
qed

end
