theory question_75_8

theory Friction_Slowing_Down
  imports
    Physical_Interactions.Motion
    Physical_Interactions.Surface
    Physical_Interactions.Friction
begin

definition "slowing_down" := λx, ¬ accelerating x

axiomatization where
  slowing_down: ∀x, slowing_down x ↔ ¬ accelerating x

theorem "friction_slowing_down" : ∀x y, friction x y ∧ slowing_down x ↔ ¬ accelerating y
proof -
  from asm have "Friction x y" by simp
  then obtain e1 where e1: "slowing_down x" using explanation_2 by blast
  then have "contact x y" using explanation_3 by blast
  then have "surface x y" using explanation_4 by blast
  then have "pushing x y" using explanation_5 by blast
  then have "pulling x y" using explanation_6 by blast
  then have "counter x y" using explanation_8 by blast
  then have "rolling x y" using explanation_9 by blast
  then have "ball x y" using explanation_10 by blast
  then have "force e1" using explanation_11 by blast
  then show ?thesis using asm e1 by simp
qed

end
