theory question_90_7

imports Main

begin

typedecl entity
typedecl event

consts
 Worker :: "entity ⇒ bool"
 Bent :: "entity ⇒ bool"
 PullingGrass :: "event ⇒ bool"
 Agent :: "event ⇒ entity ⇒ bool"
 Patient :: "event ⇒ entity ⇒ bool"
 In :: "event ⇒ entity ⇒ bool"

(* Explanation 1: If three workers are bent over, they are pulling grass. *)
axiomatization where
 explanation_1: "∀x y e. Worker x ∧ Bent y ∧ Agent e x ∧ Patient e y ⟶ PullingGrass e"

theorem hypothesis:
 (* Premise: Three workers bent over pulling grass. *)
 assumes asm: "Worker x ∧ Bent y ∧ PullingGrass z ∧ Agent e x ∧ Patient e y ∧ In e z"
 (* Hypothesis: Three workers bent over. *)
 shows "∃x y e. Worker x ∧ Bent y ∧ Agent e x ∧ Patient e y"
proof -
 from asm have "Worker x ∧ Bent y ∧ PullingGrass z ∧ Agent e x ∧ Patient e y ∧ In e z" by blast
 then have "Worker x ∧ Bent y ∧ Agent e x ∧ Patient e y" using explanation_1 by blast
 then have "Worker x ∧ Bent y ∧ PullingGrass z" using explanation_2 by blast
 then show ?thesis using `Worker x` `Bent y` `PullingGrass z` by blast
qed

end
