theory question_50_3

imports Main

begin

typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Racetrack :: "entity ⇒ bool"
  DirtBike :: "entity ⇒ bool"
  Riding :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  On :: "event ⇒ entity ⇒ bool"
  BeingRiddenBy :: "event ⇒ entity ⇒ bool"

(* Explanation 1: A man is riding a dirt bike on a racetrack. *)
axiomatization where
  explanation_1: "∃x y e. Man x ∧ Racetrack y ∧ DirtBike e ∧ Riding e ∧ Agent e x ∧ On e y"

(* Explanation 2: The man is riding the dirt bike. *)
axiomatization where
  explanation_2: "∃x e. Man x ∧ DirtBike e ∧ Riding e ∧ Agent e x"

(* Explanation 3: The dirt bike is being ridden by the man. *)
axiomatization where
  explanation_3: "∃x e. DirtBike e ∧ Man x ∧ Riding e ∧ Agent e x ∧ BeingRiddenBy e x"

theorem hypothesis:
  (* Premise: A man is riding a dirt bike on a racetrack. *)
  assumes asm: "Man x ∧ Racetrack y ∧ DirtBike e ∧ Riding e ∧ Agent e x ∧ On e y"
  (* Hypothesis: A man is riding a dirt bike. *)
  shows "∃x e. Man x ∧ DirtBike e ∧ Riding e ∧ Agent e x"
proof -
  from asm have "Man x" by blast
  from this have "DirtBike e" using explanation_1 by blast
  from asm have "Riding e" by blast
  from this have "Agent e x" using explanation_1 by blast
  show ?thesis using `Man x` `DirtBike e` `Riding e` `Agent e x` by blast
qed

end
