theory question_65_1

imports Main

begin

typedecl entity
typedecl event

consts
  Electricity :: "entity ⇒ bool"
  LightBulb :: "entity ⇒ bool"
  Flows :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  TurnOn :: "event ⇒ bool"
  ComeOn :: "event ⇒ bool"
  Switch :: "entity ⇒ bool"
  SimpleSeriesCircuit :: "entity ⇒ bool"
  Closed :: "event ⇒ bool"
  Flow :: "event ⇒ bool"

(* Explanation 1: When electricity flows to a light bulb, the light bulb will turn on; come on. *)
axiomatization where
  explanation_1: "∀x y e1 e2 e3. Electricity x ∧ LightBulb y ∧ Flows e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ (TurnOn e2 ∧ Agent e2 y) ∨ (ComeOn e3 ∧ Agent e3 y)"

(* Explanation 2: When a switch in a simple series circuit is closed, electricity will flow to the light bulb in the circuit. *)
axiomatization where
  explanation_2: "∀x y z e1 e2. Switch x ∧ SimpleSeriesCircuit y ∧ LightBulb z ∧ Closed e1 ∧ Agent e1 x ∧ Patient e1 y ⟶ Flow e2 ∧ Agent e2 y ∧ Patient e2 z"  

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: "Switch x ∧ SimpleSeriesCircuit y ∧ Closed e ∧ Agent e x ∧ Patient e y"
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃x y e1 e2. Electricity x ∧ LightBulb y ∧ Flow e1 ∧ Agent e1 x ∧ Patient e1 y ∧ ComeOn e2 ∧ Agent e2 y"
proof -
  from asm obtain e2 where e2: "Flow e2 ∧ Agent e2 y ∧ Patient e2 z" using explanation_2 by blast
  then have "Electricity y ∧ LightBulb z" by simp
  then obtain e3 where e3: "ComeOn e3 ∧ Agent e3 z" using explanation_1 by blast
  show ?thesis using asm e2 `Electricity y` `LightBulb z` e3 by blast
qed

end
