theory question_27_0

imports Main

begin
typedecl entity
typedecl event

consts
  Man :: "entity ⇒ bool"
  Sidewalk :: "entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Dirty :: "entity ⇒ bool"
  Outside :: "entity ⇒ bool"
  Old :: "entity ⇒ bool"
  HardwareParts :: "entity ⇒ bool"
  Sells :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"

(* Explanation 1: The man is on a dirty sidewalk. Sidewalks are found outdoors, therefore, the man is outside *)
axiomatization where
  explanation_1: "∀x y. Man x ∧ Sidewalk y ∧ On x y ∧ Dirty y ⟶ Outside x"

theorem hypothesis:
  (* Premise: An old man sells hardware parts on a dirty sidewalk. *)
  assumes asm: "Man x ∧ Old x ∧ HardwareParts y ∧ Sidewalk z ∧ Dirty z ∧ Sells e ∧ Agent e x ∧ Patient e y ∧ On x z"
  (* Hypothesis: The man is outside. *)
  shows "∃x. Man x ∧ Outside x"
proof -
  from asm have "Man x ∧ Sidewalk z ∧ On x z ∧ Dirty z" by blast
  then have "Outside x" using explanation_1 by blast
  then show ?thesis using `Man x` `Outside x` by blast
qed

end
