theory question_65_1
imports Main
begin

typedecl entity
typedecl event

consts
  ElectricityFlows :: "event ⇒ bool"
  ToLightBulb :: "event ⇒ bool"
  LightComesOn :: "event ⇒ bool"
  Cause :: "event ⇒ event ⇒ bool"

(* Explanation 1: When electricity flows to a light bulb, the light comes on. *)
axiomatization where
  explanation_1: "∃e. ElectricityFlows e ∧ ToLightBulb e ⟶ (∃e1. LightComesOn e1 ∧ Cause e e1)"

theorem hypothesis:
  (* Premise: when the switch in a simple series circuit is closed *)
  assumes asm: ""
  (* Hypothesis: When electricity is flowing to the light bulb, the light comes on. *)
  shows "∃e. ElectricityFlows e ∧ ToLightBulb e ∧  LightComesOn e1 ∧ Cause e e1 "
proof -
  have "∃e1. LightComesOn e1 ∧ Cause e e1" using explanation_1 by blast
  then obtain e1 where e1: "LightComesOn e1 ∧ Cause e e1" by blast
  have "ElectricityFlows e ∧ ToLightBulb e" using asm explanation_2 explanation_4 explanation_5 explanation_6 by blast
  then show ?thesis using `ElectricityFlows e ∧ ToLightBulb e` e1 by blast
qed

end
