import matplotlib.pyplot as plt
from matplotlib.pyplot import savefig
import numpy as np
from matplotlib.pyplot import MultipleLocator
  
# initialize x and y coordinates 
# AULA-CP
bias_score = [44.03,44.83,45.82,45.42,43.9,46.62,44.96,46.15,47.35,47.35,48.21]
age = [52.87,56.32,58.62,59.77,56.32,57.47,51.72,52.87,57.47,56.32,60.92]
disability = [73.33, 65, 70, 71.67, 66.67, 65, 66.67, 63.33, 66.67, 66.67, 58.33]
gender= [43.89,48.09,49.62,46.95,46.18,48.47,50,51.53,50,50.76,49.24]
nationality = [44.03,42.14,40.88,39.62,40.88,41.51,40.25,44.03,45.28,44.65,42.77]
physical_appearance = [46.03,52.38,52.38,58.73,61.9,57.14,50.79,50.79,50.79,49.21,55.56]
race_color = [33.33,33.14,34.5,34.5,33.53,38.37,36.63,50.79,41.47,43.22,44.38]
religion = [36.19,36.19,39.05,40,39.05,47.62,49.52,48.57,48.57,40,46.67]
sexual_orientation = [63.1,67.86,70.24,67.86,67.86,64.29,59.52,57.14,57.14,55.95,57.14]
socioeconomic = [56.4,55.81,53.49,52.33,44.77,48.26,43.6,45.93,44.19,45.35,47.09]

# AULA-SS
# bias_score = [56.27,56.22,56.17,55.37,57.36,57.74,58.17,58.45,57.36,57.64,58.83]
# gender = [53.73,54.12,57.65,57.25,58.43,56.47,59.61,59.61,59.22,60.78,61.18]
# profession = [56.79,56.54,56.54,54.07,57.78,58.02,59.51,60.25,60.25,59.63,61.23]
# race = [56.96,57.17,55.72,56.24,56.96,57.9,56.65,56.34,54.37,54.99,55.82]
# religion = [50.63,48.1,53.16,51.9,54.43,56.96,58.23,62.03,58.23,59.49,63.29]

time = ['Mar 2020', 'Jun 2020', 'Sep 2020', 'Dec 2020', 'Mar 2021', 'Jun 2021', 'Sep 2021',
 'Dec 2021', 'Mar 2022', 'Jun 2022', 'Sep 2022']

# plot scatter plot with x and y data 
plt.figure(figsize=(7, 6), dpi=200)

plt.scatter(time, bias_score)

## CP
plt.scatter(time, age) 
plt.scatter(time, disability)
plt.scatter(time, gender)
plt.scatter(time, nationality)
plt.scatter(time, physical_appearance)
plt.scatter(time, race_color)
plt.scatter(time, religion)
plt.scatter(time, sexual_orientation)
plt.scatter(time, socioeconomic)


# plot with x and y data 
plt.plot(time, bias_score, label='bias score')

## CP
plt.plot(time, age, label='age')
plt.plot(time, disability, label='disability')
plt.plot(time, gender, label='gender')
plt.plot(time, nationality, label='nationality')
plt.plot(time, physical_appearance, label='physical appearance')
plt.plot(time, race_color, label='race color')
plt.plot(time, religion, label='religion')
plt.plot(time, sexual_orientation, label='sexual orientation')
plt.plot(time, socioeconomic, label='socioeconomic')
plt.ylim(30, 80)

## SS
# plt.scatter(time, gender)
# plt.scatter(time, profession)
# plt.scatter(time, race)
# plt.scatter(time, religion)

# plt.plot(time, gender, label='gender')
# plt.plot(time, profession, label='profession')
# plt.plot(time, race, label='race')
# plt.plot(time, religion, label='religion')

# y_major_locator = MultipleLocator(5)
# ax = plt.gca()
# ax.yaxis.set_major_locator(y_major_locator)
# plt.ylim(45, 65)

plt.xticks(rotation=30, size = 9)

# plt.legend(loc="upper right", bbox_to_anchor=(1.40, 0.95))
# plt.legend(loc="upper right", bbox_to_anchor=(1.26, 0.95))
plt.legend(loc="upper right",  fontsize=10, ncol=2)
plt.ylabel('AULA-CP', fontsize=12)


path = 'results/aula-cp.png'
savefig(path, dpi=None, facecolor='w', edgecolor='w',
        orientation='portrait',
        transparent=False, bbox_inches='tight', pad_inches=0.1, metadata=None)

