import matplotlib.pyplot as plt
from matplotlib.pyplot import savefig
import numpy as np
from matplotlib.pyplot import MultipleLocator
  
# initialize x and y coordinates 
# AULA-CP

## age
# bias_score = [52.87,56.32,58.62,59.77,56.32,57.47,51.72,52.87,57.47,56.32,60.92]
# demographic_1 = [67.60,68.35,68.53,67.73,66.51,64.01,64.49,64.07,65.77,67.69,68.44]
# demographic_2 = [57.65,57.60,58.16,54.46,56.73,55.35,56.96,55.73,59.13,59.67,60.34]

## religion
# bias_score = [36.19,36.19,39.05,40,39.05,47.62,49.52,48.57,48.57,40,46.67]
# demographic_1 = [84.30,85.16,84.27,81.29,83.78,89.10,83.00,81.08,86.25,85.16,86.00]
# demographic_2 = [82.06,82.23,84.96,84.56,83.05,81.62,83.37,82.36,82.49,87.40,88.08]

## gender
# bias_score = [43.89,48.09,49.62,46.95,46.18,48.47,50,51.53,50,50.76,49.24]
# demographic_1 = [62.05,64.01,63.53,61.90,60.79,57.96,61.45,58.64,59.76,62.51,63.77]
# demographic_2 = [30.17,31.01,31.44,31.28,30.97,29.83,30.24,30.55,31.74,32.65, 31.84]

## race
bias_score = [33.33,33.14,34.5,34.5,33.53,38.37,36.63,50.79,41.47,43.22,44.38]
demographic_1 = [68.21,69.75,67.56,68.99,65.69,61.46,61.86,59.07,60.70,65.62,68.02]
demographic_2 = [56.66,59.01,59.37,58.72,58.27,53.70,57.79,55.60,59.50,60.75,61.35]

time = ['Mar 2020', 'Jun 2020', 'Sep 2020', 'Dec 2020', 'Mar 2021', 'Jun 2021', 'Sep 2021',
 'Dec 2021', 'Mar 2022', 'Jun 2022', 'Sep 2022']

# plot scatter plot with x and y data 
plt.figure(figsize=(7, 6), dpi=200)

plt.scatter(time, bias_score)
plt.scatter(time, demographic_1) 
plt.scatter(time, demographic_2)



# plot with x and y data 
plt.plot(time, bias_score, label='Race', linestyle='dashed')
plt.plot(time, demographic_1, label='Black')
plt.plot(time, demographic_2, label='White')
# plt.ylim(-0.2, 1.2)

## SS
# plt.scatter(time, gender)
# plt.scatter(time, profession)
# plt.scatter(time, race)
# plt.scatter(time, religion)

# plt.plot(time, gender, label='gender')
# plt.plot(time, profession, label='profession')
# plt.plot(time, race, label='race')
# plt.plot(time, religion, label='religion')

# y_major_locator = MultipleLocator(5)
# ax = plt.gca()
# ax.yaxis.set_major_locator(y_major_locator)
# plt.ylim(45, 65)

plt.xticks(rotation=30, size = 9)

# plt.legend(loc="upper right", bbox_to_anchor=(1.40, 0.95))
# plt.legend(loc="upper right", bbox_to_anchor=(1.26, 0.95))
plt.legend(loc="lower right",  fontsize=10, ncol=1)
plt.ylabel('bias score', fontsize=12)


path = 'results/race.png'
savefig(path, dpi=None, facecolor='w', edgecolor='w',
        orientation='portrait',
        transparent=False, bbox_inches='tight', pad_inches=0.1, metadata=None)

