import torch
from random import seed




def fix_seed():
    torch.manual_seed(1)
        # 在神经网络中，参数默认是进行随机初始化的。如果不设置的话每次训练时的初始化都是随机的，导致结果不确定。如果设置初始化，则每次初始化都是固定的
    torch.backends.cudnn.enabled = False
        # if true, cuDNN使用的非确定性算法就会自动寻找最适合当前配置的高效算法，来达到优化运行效率的问题
    torch.backends.cudnn.benchmark = False
        # https://zhuanlan.zhihu.com/p/73711222
    torch.backends.cudnn.deterministic = True
        # 确定的优化算法，优化算法中可能也包含了随机性
    seed(43)
    return 