/*
 * Decompiled with CFR 0.152.
 */
package annotation_scorers;

import java.util.HashMap;
import xml_parsers.XmlAttribs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Judgement
implements Comparable<Judgement> {
    private int judgement;
    private String element;
    private HashMap<String, String> attribs;
    private HashMap<String, String> alt_annot_attribs;
    private HashMap<String, Integer> alt_annot_attribs_scores;
    private int numline;
    private String keylines;
    private String annotlines;

    public Judgement(int j, String elem, String attrs, int nline, String keyline, String annotline) {
        block4: {
            try {
                if (elem == null || keyline == null || annotline == null) {
                    throw new Exception("Null element, keyline or annotline");
                }
                judgements jdm = judgements.values()[j];
                this.judgement = j;
                this.element = elem;
                this.attribs = XmlAttribs.parseXMLattrs(attrs);
                if (this.attribs.isEmpty()) {
                    this.attribs = XmlAttribs.parseSemiColonAttrs(attrs);
                }
                this.alt_annot_attribs = null;
                this.numline = nline;
                this.keylines = keyline;
                this.annotlines = annotline;
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block4;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public void changeJudgement(int j) {
        block2: {
            try {
                judgements jdm = judgements.values()[j];
                this.judgement = j;
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block2;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public void updateNumline(int newnum) {
        this.numline = newnum;
    }

    public void extendJudgement(String keyline, String annotline) {
        block3: {
            try {
                if (keyline == null || annotline == null) {
                    throw new Exception("Null keyline or annotline");
                }
                this.keylines = this.keylines + "\n" + keyline;
                this.annotlines = this.annotlines + "\n" + annotline;
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block3;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public void changeAndExtendJudgement(int j, String keyline, String annotline) {
        block3: {
            try {
                if (keyline == null || annotline == null) {
                    throw new Exception("Null keyline or annotline");
                }
                judgements jdm = judgements.values()[j];
                this.judgement = j;
                this.keylines = this.keylines + "\n" + keyline;
                this.annotlines = this.annotlines + "\n" + annotline;
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block3;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public void add_alt_attribs(String attrs, String type) {
        block12: {
            try {
                if (type.equals("key")) {
                    this.alt_annot_attribs = this.attribs;
                    this.attribs = XmlAttribs.parseXMLattrs(attrs);
                    if (this.attribs.isEmpty()) {
                        this.attribs = XmlAttribs.parseSemiColonAttrs(attrs);
                    }
                } else if (type.equals("annot")) {
                    this.alt_annot_attribs = XmlAttribs.parseXMLattrs(attrs);
                    if (this.alt_annot_attribs.isEmpty()) {
                        this.alt_annot_attribs = XmlAttribs.parseSemiColonAttrs(attrs);
                    }
                } else {
                    throw new Exception("alt_attribs type must be 'key' or 'annot'");
                }
                this.alt_annot_attribs_scores = new HashMap();
                for (String key : this.attribs.keySet()) {
                    this.alt_annot_attribs_scores.put(key, judgements.valueOf("miss").ordinal());
                }
                for (String key : this.alt_annot_attribs.keySet()) {
                    if (this.alt_annot_attribs_scores.get(key) != null) {
                        if (this.attribs.get(key).equalsIgnoreCase(this.alt_annot_attribs.get(key))) {
                            this.alt_annot_attribs_scores.put(key, judgements.valueOf("corr").ordinal());
                            continue;
                        }
                        this.alt_annot_attribs_scores.put(key, judgements.valueOf("inco").ordinal());
                        continue;
                    }
                    this.alt_annot_attribs_scores.put(key, judgements.valueOf("spur").ordinal());
                }
            }
            catch (Exception e) {
                System.err.println("Errors found (" + this.getClass().getSimpleName() + "):\n\t" + e.toString() + "\n");
                if (System.getProperty("DEBUG") == null || !System.getProperty("DEBUG").equalsIgnoreCase("true")) break block12;
                e.printStackTrace(System.err);
                System.exit(1);
            }
        }
    }

    public int getJugement() {
        return this.judgement;
    }

    public String getJudgement_str() {
        return judgements.values()[this.judgement].toString();
    }

    public int getJudgement_int() {
        return judgements.values()[this.judgement].ordinal();
    }

    public String getElement() {
        return this.element;
    }

    public HashMap<String, String> getAttribs() {
        return this.attribs;
    }

    public String getAttrib(String key) {
        return this.attribs.get(key);
    }

    public boolean containsAttrib(String key) {
        return this.attribs.containsKey(key);
    }

    public String getXMLattribs() {
        String xmlattrs = "";
        for (String key : this.attribs.keySet()) {
            xmlattrs = xmlattrs + " " + key + "=\"" + this.attribs.get(key) + "\"";
        }
        if (xmlattrs.equals("")) {
            xmlattrs = "*";
        }
        return xmlattrs;
    }

    public HashMap<String, String> get_alt_attribs() {
        return this.alt_annot_attribs;
    }

    public String get_alt_attrib(String key) {
        return this.alt_annot_attribs.get(key);
    }

    public String getXMLalt_attribs() {
        String xmlattrs = "";
        for (String key : this.alt_annot_attribs.keySet()) {
            xmlattrs = xmlattrs + " " + key + "=\"" + this.alt_annot_attribs.get(key) + "\"";
        }
        if (xmlattrs.equals("")) {
            xmlattrs = "*";
        }
        return xmlattrs;
    }

    public HashMap<String, Integer> get_alt_attribs_scores() {
        return this.alt_annot_attribs_scores;
    }

    public Integer get_alt_attrib_score(String key) {
        return this.alt_annot_attribs_scores.get(key);
    }

    public int getNumline() {
        return this.numline;
    }

    public String getKeylines() {
        return this.keylines;
    }

    public String getAnnotlines() {
        return this.annotlines;
    }

    public Boolean isAligned() {
        if (this.judgement == judgements.valueOf("corr").ordinal() || this.judgement == judgements.valueOf("inco").ordinal()) {
            return true;
        }
        return false;
    }

    @Override
    public int compareTo(Judgement obj) {
        int result = this.getNumline() - obj.getNumline();
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum judgements {
        corr,
        inco,
        spur,
        miss;

    }
}

