#!/usr/bin/env python
import pandas as pd
import argparse
from indictrans import Transliterator
import re

def is_english(s: str) -> bool:
    if len(re.findall(u'[\u0900-\u097F]', s)) <= 1000:
        return True
    return False

if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("-i", default=None, type=str, required=True, help="Dataset csv file")
    args = parser.parse_args()


# df = pd.DataFrame()
df = pd.read_csv(args.i)

trn = Transliterator(source='eng', target='kan', build_lookup=True)

for i in range(len(df)):
    print(i)
    if i == 175 or i == 463 or df['Sentence'].iloc[i] is '':
        continue
    else:
        df['Sentence'] = df['Sentence'].replace(df['Sentence'].iloc[i], trn.transform(df['Sentence'].iloc[i]))

# print(df)
df.to_csv('final_test.csv')
