import React, { Component } from 'react';
import { withTracker } from 'meteor/react-meteor-data';
import { Redirect } from "react-router-dom";

import Instructions from './Instructions.jsx';
import TextDoc from './TextDoc.jsx';
import MTurk from './MTurk.jsx';
import SentimentTask from './SentimentTask.jsx';
import { Texts, Annotations, Assignments } from '../api/documents';
import { gup } from '../util/gup.js';

export class WorkerPreview extends Component {
  constructor(props) {
    super(props);
  }

  handleSubmit() {
  }

  render() {
    if (this.props.areReady) {
      const assign_id = gup("internalAssignment");
      const assignment = this.props.assignments.find(assignment => {
        return assignment._id == assign_id;
      });
      const text = this.props.texts.find(text => {
        return text._id == assignment.text_id;
      });
      const annotation = this.props.annotations.find(ann => {
        return ann._id == assignment.ann_id;
      });
      if (text != undefined && annotation != undefined) {
        if (this.props.match.params.ui == "sentiment") {
          return (
            <div>
              <SentimentTask
                text={text}
                ann_id={annotation._id}
                clusters={annotation.clusters}
                validate={this.markDone}
                readOnly={true}
                showModal={this.handleOpenModal}
              />
              <div className="clear">
              </div>
              <div className="center-buttons">
                <button className="noselect button big" onClick={this.handleSubmit}>
                  Done
                </button>
              </div>
            </div>
          );
        } else {
          return (
            <div> 
              <Instructions 
                ui={this.props.match.params.ui}
                labels={annotation.labels}
              />
              <TextDoc
                text={text}
                clusters={annotation.clusters}
                checks={annotation.checks}
                key={annotation._id}
                ann_id={annotation._id}
                labelOptions={annotation.labels}
                ui={this.props.match.params.ui}
                validate={this.markDone}
                readOnly={true}
                focusMention={assignment.focus_mention}
              />
              <div className="clear">
              </div>
              <div className="center-buttons">
                <button className="noselect button big" onClick={this.handleSubmit}>
                  Done
                </button>
              </div>
            </div>
          );
        }
      }
    }

    return (
      <p>
      Loading...
      </p>
    );
  }
}

export default WorkerPreviewContainer = withTracker(() => {
  const text_id = gup("textId");
  const assign_id = gup("internalAssignment");

  const handles = [
    Meteor.subscribe('texts-single', text_id),
    Meteor.subscribe('annotations-user', "server"),
    Meteor.subscribe('assignments-single', assign_id),
  ];
 
  return {
    texts: Texts.find().fetch(),
    annotations: Annotations.find().fetch(),
    assignments: Assignments.find().fetch(),
    areReady: handles.every(handle => handle.ready()),
  };
})(WorkerPreview);
