'''
The format of quoref data used in tase model is different with the original quoref dataset.
This script reformat original quoref QA so that it is consistent with the tase data_reader.
'''

import json
import sys
import uuid

if __name__ == "__main__":
	file_name = sys.argv[1]
	with open(file_name, "r") as f:
		data = json.load(f)["data"]

	tase_format_data = {}
	for paragraphs in data:
		for context in paragraphs["paragraphs"]:
			if "context_id" in context.keys():
				context_id = context["context_id"]
			else:
				context_id = uuid.uuid1().hex
			qa_pairs = []
			for qa in context["qas"]:
				new_qa = {"question": qa["question"], "query_id": qa["id"],
			  	    	  "answer": {"number": "", "date": {"day": "", "month": "", "date": ""},
			                		 "spans": [answer["text"] for answer in qa["answers"]]},
			  		      "original_answer": qa["answers"]}
				qa_pairs.append(new_qa)
			# tase_format_data[context_id] = {"passage": context["context"], "wiki_url": paragraphs["url"],
			# 		    "title": paragraphs["title"], "qa_pairs": qa_pairs}
	
			tase_format_data[context_id] = {"passage": context["context"], "wiki_url": "",
			 	 		    "title": paragraphs["title"], "qa_pairs": qa_pairs}
	output = file_name[:-5] + "-tase.json"
	with open(output, "w") as f_o:
		json.dump(tase_format_data, f_o, indent=4)

    
