import warnings
class BasicConfig(object):
    data_dir = './ja_100_char/'  # input data_processing path
    out_dir = './ja_test/'

    ckp_dir = data_dir
    input_test_file = 'ja_test'
    # data parameters
    lang = 'ja' # 'de' | 'ja'
    lang_mode = 'char' # 'char' | 'word'
    loss_func = 'cross_entropy' # max_margin | cross_entropy
    target_field = 'lemma'  # 'lemma'| 'inflected' |'tense'(only for japanese)
    balance_flag = False  # equal number of samples for each class(verb)
    source_vocab_size = 50000
    num_verbs = 100
    use_pretrained_embed = False
    split_p = 0 # proportion of data used for complete sentences
    portion = [0.3, 0.5, 0.7, 0.9, 1.0]  # subsentences split portion
    reverse = False  # reverse portion order
    fix_portion = 0  # train and test on subsentences of length with fixed_portion, if zero then use all subsentences

    # model set up
    model = 'indePred'
    rnn_type = 'GRU'
    sampler = 'random'  # 'weighted' or 'random' or 'None'
    shuffling = True

    add_pos_embed = False                      # 1. add pos tag embedding to embedding vector
    cnn_rnn = False                           # 2. add cnn before rnn
    apply_attn = True                         # 3. apply attention and obtain weighted context
    attn_type = 'structured_self_attn'        # 3.1 apply attention type: 'structured_self_attn' | 'self_attn'
    if attn_type=='structured_self_attn':     # 3.2 sett attn hyper-parameter if use structured self attn
        da = 64
        r = 5
        follow_paper=True                     # if True use attention matrix, otherwise use averaged attention vector
    combine_hidden = False                    # 4. hidden state type: if False, concat hidden, if true combine hidden
    add_target_embed = False                  # 5. apply target_embed, use bilinear as out layer, if False, linear

    # model hyper parameter
    embed_size = 64
    hidden_size = 256
    batch_size = 3
    nlayers = 2
    log_interval = 10
    eval_interval = 20
    lr = 0.0001
    lr_decay = 0.1
    drop_embed_prob = 0.6
    variational_dropout_prob = 0.2
    drop_rnn_prob = 0
    drop_out_prob = 0
    is_bidirectional = True

    num_epochs = 10
    load_ckp = False



def parse(self, kwargs):
    for k, v in kwargs.items():
        if not hasattr(self, k):
            warnings.warn("Warning: opt has no attribute %s" % k)
        setattr(self, k, v)

    print('user config:')
    for k, v in self.__class__.__dict__.items():
        if not k.startswith('__'):
            print(k, getattr(self, k))


BasicConfig.parse = parse
basic_opt = BasicConfig()
