function candoit = canGetSqrtPrecon(problem)
% Checks whether a square root of preconditioner was specified in problem.
%
% function candoit = canGetSqrtPrecon(problem)
%
% Returns true if the problem structure allows for applying the square root
% of a preconditioner to tangent vectors at a given point. The square root
% of the preconditioner at x must be a symmetric, positive definite
% operator Q such that applying Q twice (Q o Q) amounts to applying the
% preconditioner once. If both a preconditioner and a square root of
% preconditioner are provided, it is the user's responsibility to ensure
% their compatibility.
%
% Similarly to getPrecon, if the present function returns false, calls to
% getSqrtPrecon will still work: they will act as the identity. Note that
% this may be incompatible with the preconditioner if it is given. Thus,
% always check by calling canGetSqrtPrecon first.
%
% See also: canGetPrecon getSqrtPrecon getPrecon

% This file is part of Manopt: www.manopt.org.
% Original author: Nicolas Boumal, April 3, 2015.
% Contributors: 
% Change log: 

    candoit = isfield(problem, 'sqrtprecon');
    
end
