import os


def write_results(results_dir, file_name, validation_results, opt):
    _, _, f_score_final = validation_results['All'][-1]
    file_name = file_name + "_Fscore={:.3f}.json".format(f_score_final)
    print(file_name)
    write_results_path = os.path.join(results_dir, file_name)
    f = open(write_results_path, 'w+', encoding='utf-8')
    for validation_setting in validation_results:
        print(validation_setting)
        f.write(str(validation_setting) + "\n")
        for results_per_epoch in validation_results[validation_setting]:
            if hasattr(results_per_epoch, 'data'):
                # Loss should be a Variable wrapping a Tensor storing the loss
                loss_val = results_per_epoch.data[0]
                print(loss_val)
                f.write(str(loss_val) + '\n')
            else:
                p_score, r_score, f_score = results_per_epoch
                print("          micro P={:.3f} R={:.3f} F={:.3f}".format(p_score, r_score, f_score))
                f.write("          micro P={:.3f} R={:.3f} F={:.3f} \n".format(p_score, r_score, f_score))
    f.write("\n")
    f.write("\n")
    f.write("\n")
    f.write("All model parameters \n")
    for param in vars(opt):
        val = (getattr(opt, param))
        print("{}: {}".format(param, val))
        f.write("{}: {}\n".format(param, val))
