/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.stats.ClassicCounter;
import edu.stanford.nlp.stats.Counter;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filter;
import edu.stanford.nlp.util.Generics;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Dependencies {
    private Dependencies() {
    }

    public static Map<TreeGraphNode, List<TypedDependency>> govToDepMap(List<TypedDependency> deps) {
        Map<TreeGraphNode, List<TypedDependency>> govToDepMap = Generics.newHashMap();
        for (TypedDependency dep : deps) {
            TreeGraphNode gov = dep.gov();
            List<TypedDependency> depList = govToDepMap.get(gov);
            if (depList == null) {
                depList = new ArrayList<TypedDependency>();
                govToDepMap.put(gov, depList);
            }
            depList.add(dep);
        }
        return govToDepMap;
    }

    private static Set<List<TypedDependency>> getGovMaxChains(Map<TreeGraphNode, List<TypedDependency>> govToDepMap, TreeGraphNode gov, int depth) {
        Set<List<TypedDependency>> depLists = Generics.newHashSet();
        List<TypedDependency> children = govToDepMap.get(gov);
        if (depth > 0 && children != null) {
            for (TypedDependency child : children) {
                TreeGraphNode childNode = child.dep();
                if (childNode == null) continue;
                Set<List<TypedDependency>> childDepLists = Dependencies.getGovMaxChains(govToDepMap, childNode, depth - 1);
                if (childDepLists.size() != 0) {
                    for (List<TypedDependency> childDepList : childDepLists) {
                        ArrayList<TypedDependency> depList = new ArrayList<TypedDependency>(childDepList.size() + 1);
                        depList.add(child);
                        depList.addAll(childDepList);
                        depLists.add(depList);
                    }
                    continue;
                }
                depLists.add(Arrays.asList(child));
            }
        }
        return depLists;
    }

    public static Counter<List<TypedDependency>> getTypedDependencyChains(List<TypedDependency> deps, int maxLength) {
        Map<TreeGraphNode, List<TypedDependency>> govToDepMap = Dependencies.govToDepMap(deps);
        ClassicCounter<List<TypedDependency>> tdc = new ClassicCounter<List<TypedDependency>>();
        for (TreeGraphNode gov : govToDepMap.keySet()) {
            Set<List<TypedDependency>> maxChains = Dependencies.getGovMaxChains(govToDepMap, gov, maxLength);
            for (List<TypedDependency> maxChain : maxChains) {
                for (int i = 1; i <= maxChain.size(); ++i) {
                    List<TypedDependency> chain = maxChain.subList(0, i);
                    tdc.incrementCount(chain);
                }
            }
        }
        return tdc;
    }

    public static Comparator<Dependency> dependencyIndexComparator() {
        return ComparatorHolder.dc;
    }

    private static class ComparatorHolder {
        private static final Comparator<Dependency> dc = new DependencyIdxComparator();

        private ComparatorHolder() {
        }

        private static class DependencyIdxComparator
        implements Comparator<Dependency> {
            private DependencyIdxComparator() {
            }

            @Override
            public int compare(Dependency dep1, Dependency dep2) {
                CoreMap dep1lab = (CoreMap)dep1.dependent();
                CoreMap dep2lab = (CoreMap)dep2.dependent();
                Integer dep1idx = (Integer)dep1lab.get(CoreAnnotations.IndexAnnotation.class);
                Integer dep2idx = (Integer)dep2lab.get(CoreAnnotations.IndexAnnotation.class);
                return dep1idx - dep2idx;
            }
        }
    }

    public static class DependentPuncWordRejectFilter<G extends Label, D extends Label, N>
    implements Filter<Dependency<G, D, N>> {
        private static final long serialVersionUID = 1166489968248785287L;
        private final Filter<String> wordRejectFilter;

        public DependentPuncWordRejectFilter(Filter<String> wrf) {
            this.wordRejectFilter = wrf;
        }

        @Override
        public boolean accept(Dependency<G, D, N> d) {
            if (d == null) {
                return false;
            }
            String word = null;
            if (d.dependent() instanceof HasWord) {
                word = ((HasWord)d.dependent()).word();
            }
            if (word == null) {
                word = d.dependent().value();
            }
            return this.wordRejectFilter.accept(word);
        }
    }

    public static class DependentPuncTagRejectFilter<G extends Label, D extends Label, N>
    implements Filter<Dependency<G, D, N>> {
        private Filter<String> tagRejectFilter;
        private static final long serialVersionUID = -7732189363171164852L;

        public DependentPuncTagRejectFilter(Filter<String> trf) {
            this.tagRejectFilter = trf;
        }

        @Override
        public boolean accept(Dependency<G, D, N> d) {
            if (d == null) {
                return false;
            }
            if (!(d.dependent() instanceof HasTag)) {
                return false;
            }
            String tag = ((HasTag)d.dependent()).tag();
            return this.tagRejectFilter.accept(tag);
        }
    }
}

