/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex;

import edu.stanford.nlp.ling.tokensregex.MultiNodePattern;
import edu.stanford.nlp.ling.tokensregex.NodePattern;
import edu.stanford.nlp.ling.tokensregex.PhraseTable;
import edu.stanford.nlp.pipeline.ChunkAnnotationUtils;
import edu.stanford.nlp.pipeline.CoreMapAttributeAggregator;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Interval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiCoreMapNodePattern
extends MultiNodePattern<CoreMap> {
    Map<Class, CoreMapAttributeAggregator> aggregators = CoreMapAttributeAggregator.getDefaultAggregators();
    NodePattern nodePattern;

    public MultiCoreMapNodePattern() {
    }

    public MultiCoreMapNodePattern(NodePattern nodePattern) {
        this.nodePattern = nodePattern;
    }

    public MultiCoreMapNodePattern(NodePattern nodePattern, Map<Class, CoreMapAttributeAggregator> aggregators) {
        this.nodePattern = nodePattern;
        this.aggregators = aggregators;
    }

    @Override
    protected Collection<Interval<Integer>> match(List<? extends CoreMap> nodes, int start) {
        ArrayList<Interval<Integer>> matched = new ArrayList<Interval<Integer>>();
        int minEnd = start + this.minNodes;
        int maxEnd = nodes.size();
        if (this.maxNodes >= 0 && this.maxNodes + start < nodes.size()) {
            maxEnd = this.maxNodes + start;
        }
        for (int end = minEnd; end <= maxEnd; ++end) {
            CoreMap chunk = ChunkAnnotationUtils.getMergedChunk(nodes, start, end, this.aggregators);
            if (!this.nodePattern.match(chunk)) continue;
            matched.add(Interval.toInterval(start, end));
        }
        return matched;
    }

    public static class StringSequenceAnnotationPattern
    extends MultiNodePattern<CoreMap> {
        Class textKey;
        PhraseTable phraseTable;

        public StringSequenceAnnotationPattern(Class textKey, Set<List<String>> targets, boolean ignoreCase) {
            this.textKey = textKey;
            this.phraseTable = new PhraseTable(false, ignoreCase, false);
            for (List<String> target : targets) {
                this.phraseTable.addPhrase(target);
                if (this.maxNodes >= 0 && target.size() <= this.maxNodes) continue;
                this.maxNodes = target.size();
            }
        }

        public StringSequenceAnnotationPattern(Class textKey, Set<List<String>> targets) {
            this(textKey, targets, false);
        }

        public StringSequenceAnnotationPattern(Class textKey, Map<List<String>, Object> targets, boolean ignoreCase) {
            this.textKey = textKey;
            this.phraseTable = new PhraseTable(false, ignoreCase, false);
            for (List<String> target : targets.keySet()) {
                this.phraseTable.addPhrase(target, null, targets.get(target));
                if (this.maxNodes >= 0 && target.size() <= this.maxNodes) continue;
                this.maxNodes = target.size();
            }
        }

        public StringSequenceAnnotationPattern(Class textKey, Map<List<String>, Object> targets) {
            this(textKey, targets, false);
        }

        @Override
        protected Collection<Interval<Integer>> match(List<? extends CoreMap> nodes, int start) {
            PhraseTable.TokenList words = new PhraseTable.TokenList(nodes, this.textKey);
            List<PhraseTable.PhraseMatch> matches = this.phraseTable.findMatches(words, start, nodes.size(), false);
            ArrayList<Interval<Integer>> intervals = new ArrayList<Interval<Integer>>(matches.size());
            for (PhraseTable.PhraseMatch match : matches) {
                intervals.add(match.getInterval());
            }
            return intervals;
        }

        public String toString() {
            return ":" + this.phraseTable;
        }
    }
}

