/*
 * Decompiled with CFR 0.152.
 */
package fig.html;

import fig.html.HtmlElement;
import fig.html.HtmlRow;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HtmlTable
extends HtmlElement {
    private List<HtmlRow> rows = new ArrayList<HtmlRow>();
    private Map<String, String> cellAttributes = new HashMap<String, String>();

    public HtmlTable() {
    }

    public HtmlTable(String id) {
        this.setAttr("id", id);
    }

    public void addRow(HtmlRow row) {
        this.rows.add(row);
    }

    @Override
    public String getTag() {
        return "table";
    }

    @Override
    protected void renderInnerHTML(StringBuilder sb, Map<String, Map<String, String>> inheritedAttributesSet) {
        inheritedAttributesSet.put("td", this.cellAttributes);
        for (HtmlRow row : this.rows) {
            row.render(sb, inheritedAttributesSet);
        }
    }

    public void setNoWrap(boolean noWrap) {
        if (noWrap) {
            this.cellAttributes.put("nowrap", null);
        } else {
            this.cellAttributes.remove("nowrap");
        }
    }
}

