#!/usr/bin/env python3

import sys
import optparse

from rule import Rule
from scfg_binarizer import SCFGBinarizer

if __name__ == '__main__':
    parser = optparse.OptionParser(description=
            'Read SCFG from stdin and write binarized grammar to stdout')
    parser.add_option('-e',
                      '--early_attach',
                      action='store_true',
                      help='early target side terminal attachment')
    parser.add_option('-c',
                      '--cost_function',
                      action='store',
                      default='b e',
                      help="""
cost function for choosing best binarization
b = binarizable
e = expectation of nodes built""")
    parser.add_option('-f',
                      '--freq_file',
                      action='store',
                      help='source language file for calculating word frequencies')
    opt, args = parser.parse_args()
    binarizer = SCFGBinarizer(opt.freq_file, opt.early_attach, opt.cost_function)
    for line in sys.stdin:
        r = Rule()
        r.fromstr(line)
        for rule in binarizer.binarize(r):
            print(rule)
    sys.stderr.write(binarizer.stats())
