/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.activities;

import edu.umd.cs.piccolo.activities.PActivity;
import edu.umd.cs.piccolo.activities.PActivityScheduler;
import edu.umd.cs.piccolo.util.PUtil;

public class PInterpolatingActivity
extends PActivity {
    public static final int SOURCE_TO_DESTINATION = 1;
    public static final int DESTINATION_TO_SOURCE = 2;
    public static final int SOURCE_TO_DESTINATION_TO_SOURCE = 3;
    private int mode;
    private boolean slowInSlowOut;
    private int loopCount;
    private boolean firstLoop;

    public PInterpolatingActivity(long l) {
        this(l, PUtil.DEFAULT_ACTIVITY_STEP_RATE, 1, 1);
    }

    public PInterpolatingActivity(long l, long l2) {
        this(l, l2, 1, 1);
    }

    public PInterpolatingActivity(long l, long l2, int n, int n2) {
        this(l, l2, System.currentTimeMillis(), n, n2);
    }

    public PInterpolatingActivity(long l, long l2, long l3, int n, int n2) {
        super(l, l2, l3);
        this.loopCount = n;
        this.mode = n2;
        this.slowInSlowOut = true;
        this.firstLoop = true;
    }

    public void setDuration(long l) {
        if (l <= 0L) {
            throw new IllegalArgumentException("Duration for PInterpolatingActivity must be greater then 0");
        }
        super.setDuration(l);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public int getLoopCount() {
        return this.loopCount;
    }

    public void setLoopCount(int n) {
        this.loopCount = n;
    }

    public boolean getFirstLoop() {
        return this.firstLoop;
    }

    public void setFirstLoop(boolean bl) {
        this.firstLoop = bl;
    }

    public boolean getSlowInSlowOut() {
        return this.slowInSlowOut;
    }

    public void setSlowInSlowOut(boolean bl) {
        this.slowInSlowOut = bl;
    }

    protected void activityStarted() {
        super.activityStarted();
        this.setRelativeTargetValueAdjustingForMode(0.0f);
    }

    protected void activityStep(long l) {
        super.activityStep(l);
        float f = (float)l / (float)this.getDuration();
        f = Math.min(1.0f, f);
        f = Math.max(0.0f, f);
        if (this.getSlowInSlowOut()) {
            f = this.computeSlowInSlowOut(f);
        }
        this.setRelativeTargetValueAdjustingForMode(f);
    }

    protected void activityFinished() {
        this.setRelativeTargetValueAdjustingForMode(1.0f);
        super.activityFinished();
        PActivityScheduler pActivityScheduler = this.getActivityScheduler();
        if (this.loopCount > 1) {
            if (this.loopCount != Integer.MAX_VALUE) {
                --this.loopCount;
            }
            this.firstLoop = false;
            this.setStartTime(pActivityScheduler.getRoot().getGlobalTime());
            pActivityScheduler.addActivity(this);
        }
    }

    public void terminate() {
        this.loopCount = 0;
        super.terminate();
    }

    public void setRelativeTargetValue(float f) {
    }

    public float computeSlowInSlowOut(float f) {
        if (f < 0.5f) {
            return 2.0f * f * f;
        }
        float f2 = 1.0f - f;
        return 1.0f - 2.0f * f2 * f2;
    }

    protected void setRelativeTargetValueAdjustingForMode(float f) {
        float f2;
        switch (this.mode) {
            case 2: {
                f2 = 1.0f - f;
                break;
            }
            case 3: {
                if (f <= 0.5f) {
                    f2 = f * 2.0f;
                    break;
                }
                f2 = 2.0f * (1.0f - f);
                break;
            }
            default: {
                f2 = f;
            }
        }
        this.setRelativeTargetValue(f2);
    }
}

