/*
 * Decompiled with CFR 0.152.
 */
package main.phrases;

import babel.content.eqclasses.phrases.Phrase;
import babel.ranking.scorers.context.FungS1Scorer;
import babel.ranking.scorers.timedistribution.TimeDistributionCosineScorer;
import babel.util.config.Configurator;
import java.util.Set;
import main.phrases.BenPhrasePreparer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BenPhraseScorer {
    protected static final Log LOG = LogFactory.getLog(BenPhraseScorer.class);
    protected static final String SRC_TO_INDUCT = "src.list";
    protected static final String TRG_TO_INDUCT = "trg.list";
    protected static final String SRC_PHRASES = "src.phrases";
    protected static final String TRG_PHRASES = "trg.phrases";
    protected static final String SRC_CONTEXT = "src.context.bin";
    protected static final String TRG_CONTEXT = "trg.context.bin";
    protected static final String SRC_TIME = "src.time.bin";
    protected static final String TRG_TIME = "trg.time.bin";

    public static void main(String[] args) throws Exception {
        LOG.info((Object)("\n" + Configurator.getConfigDescriptor()));
        BenPhraseScorer scorer = new BenPhraseScorer();
        LOG.info((Object)"===> Scoring phrases <===");
        scorer.scorePhrases();
        LOG.info((Object)"===> Done <===");
    }

    protected void scorePhrases() throws Exception {
        String outDir = Configurator.CONFIG.getString("output.Path");
        String inDir = Configurator.CONFIG.getString("preprocessing.Path");
        String srcPhraseFile = String.valueOf(inDir) + "/" + SRC_TO_INDUCT;
        String trgPhraseFile = String.valueOf(inDir) + "/" + TRG_TO_INDUCT;
        String srcPhraseOutFile = String.valueOf(outDir) + "/" + SRC_PHRASES;
        String trgPhraseOutFile = String.valueOf(outDir) + "/" + TRG_PHRASES;
        String srcContextFile = String.valueOf(outDir) + "/" + SRC_CONTEXT;
        String trgContextFile = String.valueOf(outDir) + "/" + TRG_CONTEXT;
        String srcTimeFile = String.valueOf(outDir) + "/" + SRC_TIME;
        String trgTimeFile = String.valueOf(outDir) + "/" + TRG_TIME;
        LOG.info((Object)"--- Preparing for collecting signatures ---");
        BenPhrasePreparer preparer = new BenPhrasePreparer();
        preparer.prepareContextForChunkCollection();
        this.scoreChunks(preparer, true, srcPhraseFile, srcPhraseOutFile, srcContextFile, srcTimeFile);
        this.scoreChunks(preparer, false, trgPhraseFile, trgPhraseOutFile, trgContextFile, trgTimeFile);
    }

    protected void scoreChunks(BenPhrasePreparer preparer, boolean src, String inFileName, String outFileNamePhrases, String outFileNameContext, String outFileNameTime) throws Exception {
        Set<Phrase> chunk;
        int chunkSize = Configurator.CONFIG.containsKey("preprocessing.phrases.ChunkSize") && Configurator.CONFIG.getInt("preprocessing.phrases.ChunkSize") > 0 ? Configurator.CONFIG.getInt("preprocessing.phrases.ChunkSize") : Integer.MAX_VALUE;
        boolean slidingWindow = Configurator.CONFIG.getBoolean("experiments.time.SlidingWindow");
        int windowSize = Configurator.CONFIG.getInt("experiments.time.WindowSize");
        LOG.info((Object)("--- Collecting signatures for" + (src ? " source " : " target ") + (chunkSize != Integer.MAX_VALUE ? "in chunks of size " + chunkSize : "") + " ---"));
        int chunkNum = 0;
        FungS1Scorer contextScorer = new FungS1Scorer(preparer.getSeedDict(), preparer.getMaxSrcTokCount(), preparer.getMaxTrgTokCount());
        TimeDistributionCosineScorer timeScorer = new TimeDistributionCosineScorer(windowSize, slidingWindow);
        preparer.prepareForChunkCollection(src, inFileName, chunkSize);
        preparer.openFiles(outFileNamePhrases, outFileNameContext, outFileNameTime);
        while ((chunk = preparer.prepareNextChunk(src, inFileName, chunkSize)).size() > 0) {
            LOG.info((Object)(" - Generating signatures for chunk " + chunkNum++ + "..."));
            preparer.collectContextAndTimeProps(src, chunk);
            preparer.prepareContextAndTimeProps(src, chunk, contextScorer, timeScorer);
            preparer.saveChunk(chunk);
        }
        preparer.closeFiles();
    }
}

