/*
 * Decompiled with CFR 0.152.
 */
package main.phrases;

import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.phrases.PhrasePair;
import babel.content.eqclasses.phrases.PhraseTable;
import babel.ranking.scorers.Scorer;
import babel.util.dict.SimpleDictionary;
import babel.util.misc.EditDistance;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AllPairsTokenFeatureEstimator {
    protected static final Log LOG = LogFactory.getLog(AllPairsTokenFeatureEstimator.class);
    protected static final int NUM_PAIRS_TO_GIVE = 1000;
    protected static final int PERCENT_REPORT = 5;
    protected PhraseTable m_phraseTable;
    protected Scorer m_contextScorer;
    protected Scorer m_timeScorer;
    protected SimpleDictionary m_translitDict;
    protected int m_numThreads;
    protected List<Integer> m_workerIds;
    protected LinkedList<PhrasePair> m_phrasePairsToProcess;
    protected int m_percentComplete;
    protected int m_percentThreshold;
    protected double m_completePairs;
    protected double m_totalPairs;

    protected AllPairsTokenFeatureEstimator(int numThreads, Scorer contextScorer, Scorer timeScorer, SimpleDictionary translitDict) {
        if (numThreads < 1) {
            throw new IllegalArgumentException("Must request at least one thread");
        }
        this.m_numThreads = numThreads;
        this.m_contextScorer = contextScorer;
        this.m_timeScorer = timeScorer;
        this.m_translitDict = translitDict;
        this.m_workerIds = new ArrayList<Integer>(this.m_numThreads);
        this.m_phrasePairsToProcess = new LinkedList();
    }

    public AllPairsTokenFeatureEstimator(PhraseTable phraseTable, int numThreads, Scorer contextScorer, Scorer timeScorer, SimpleDictionary translitDict) {
        this(numThreads, contextScorer, timeScorer, translitDict);
        this.m_phraseTable = phraseTable;
    }

    public synchronized void estimateFeatures(Set<Phrase> srcPhrases) throws Exception {
        this.m_workerIds.clear();
        this.m_percentComplete = 0;
        this.m_completePairs = 0.0;
        this.m_percentThreshold = 5;
        this.m_phrasePairsToProcess.clear();
        for (Phrase srcPhrase : srcPhrases) {
            for (Phrase trgPhrase : this.m_phraseTable.getTrgPhrases(srcPhrase)) {
                this.m_phrasePairsToProcess.add(new PhrasePair(srcPhrase, trgPhrase));
            }
        }
        this.m_totalPairs = this.m_phrasePairsToProcess.size();
        LOG.info((Object)(" - Estimating monolingual features for " + (int)this.m_totalPairs + " phrase pairs."));
        int threadNum = 0;
        while (threadNum < this.m_numThreads) {
            this.m_workerIds.add(threadNum);
            new Thread(new FeatureWorker(this, threadNum)).start();
            ++threadNum;
        }
        while (this.m_workerIds.size() > 0) {
            this.wait();
        }
    }

    protected synchronized List<PhrasePair> getPhrasePairsToProcess() {
        ArrayList<PhrasePair> pairsToProcess = null;
        if (this.m_phrasePairsToProcess.size() > 0) {
            pairsToProcess = new ArrayList<PhrasePair>(1000);
            int i = 0;
            while (this.m_phrasePairsToProcess.size() > 0 && i < 1000) {
                pairsToProcess.add(this.m_phrasePairsToProcess.remove());
                ++i;
            }
        }
        return pairsToProcess;
    }

    protected synchronized void estimationDone(int numComplete) {
        this.m_completePairs += (double)numComplete;
        this.m_percentComplete = (int)(100.0 * this.m_completePairs / this.m_totalPairs);
        if (this.m_percentComplete >= this.m_percentThreshold) {
            LOG.info((Object)(" - " + this.m_percentComplete + "% done."));
            this.m_percentThreshold += 5;
        }
    }

    protected synchronized void workerDone(int workerID) {
        this.m_workerIds.remove(new Integer(workerID));
        this.notify();
    }

    protected void estimateFeatures(Phrase srcPhrase, Phrase trgPhrase) {
        PhraseTable.PairProps props = this.m_phraseTable.getProps(srcPhrase, trgPhrase);
        double contextScore = this.m_contextScorer.score(srcPhrase, trgPhrase);
        double timeScore = this.m_timeScorer.score(srcPhrase, trgPhrase);
        props.setPairFeatVal(PhraseTable.PairFeat.PH_CONTEXT, contextScore);
        props.setPairFeatVal(PhraseTable.PairFeat.PH_TIME, timeScore);
        props.setPairFeatVal(PhraseTable.PairFeat.LEX_CONTEXT, contextScore);
        props.setPairFeatVal(PhraseTable.PairFeat.LEX_TIME, timeScore);
        props.setPairFeatVal(PhraseTable.PairFeat.LEX_EDIT, this.scoreEdit(srcPhrase, trgPhrase, props, this.m_translitDict));
    }

    protected double scoreEdit(Phrase srcPhrase, Phrase trgPhrase, PhraseTable.PairProps props, SimpleDictionary translitDict) {
        assert (srcPhrase.numTokens() == 1 && trgPhrase.numTokens() == 1);
        String srcWord = srcPhrase.getWord();
        String trgWord = trgPhrase.getWord();
        if (translitDict != null) {
            srcWord = this.translitWord(srcWord, translitDict);
        }
        double numEdits = EditDistance.distance(srcWord, trgWord);
        double letterCount = (double)(srcWord.length() + trgWord.length()) / 2.0;
        return numEdits / letterCount;
    }

    protected String translitWord(String word, SimpleDictionary translitDict) {
        Set<String> translits = translitDict.getTrg(word);
        return translits != null ? translits.iterator().next() : word;
    }

    class FeatureWorker
    implements Runnable {
        protected int m_workerId;
        protected AllPairsTokenFeatureEstimator m_estimator;

        public FeatureWorker(AllPairsTokenFeatureEstimator estimator, int workerId) {
            this.m_workerId = workerId;
            this.m_estimator = estimator;
        }

        @Override
        public void run() {
            List<PhrasePair> phrasePairs;
            LOG.info((Object)(" - Worker " + this.m_workerId + " started estimating monolingual features."));
            while ((phrasePairs = this.m_estimator.getPhrasePairsToProcess()) != null) {
                for (PhrasePair pair : phrasePairs) {
                    this.m_estimator.estimateFeatures(pair.srcPhrase(), pair.trgPhrase());
                }
                this.m_estimator.estimationDone(phrasePairs.size());
            }
            LOG.info((Object)(" - Worker " + this.m_workerId + " finished."));
            this.m_estimator.workerDone(this.m_workerId);
        }
    }
}

