/*
 * Decompiled with CFR 0.152.
 */
package babel.util.misc;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class GettableHashSet<E>
extends AbstractSet<E>
implements Set<E> {
    private transient HashMap<E, E> map;

    public GettableHashSet() {
        this.map = new HashMap();
    }

    public GettableHashSet(Collection<? extends E> c) {
        this.map = new HashMap(Math.max((int)((float)c.size() / 0.75f) + 1, 16));
        this.addAll(c);
    }

    public GettableHashSet(int initialCapacity, float loadFactor) {
        this.map = new HashMap(initialCapacity, loadFactor);
    }

    public GettableHashSet(int initialCapacity) {
        this.map = new HashMap(initialCapacity);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.map.containsKey(o);
    }

    public E get(E key) {
        return this.map.get(key);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, e) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this.map.remove(o) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            GettableHashSet newSet = (GettableHashSet)super.clone();
            newSet.map = (HashMap)this.map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

