/*
 * Decompiled with CFR 0.152.
 */
package babel.content.pages;

import babel.util.persistence.XMLPersistable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.nutch.metadata.Metadata;

public class MetaData
implements XMLPersistable,
Writable {
    private static final String XML_TAG_METADATA = "MetaData";
    private static final String XML_ATTRIB_TYPE = "Type";
    protected String m_typeLabel;
    protected Metadata m_metadata;

    public MetaData() {
        this(null);
    }

    public MetaData(String typeLabel) {
        this.m_typeLabel = typeLabel == null ? new String() : typeLabel;
        this.m_metadata = new Metadata();
    }

    public MetaData(String typeLabel, Metadata nutchMeta) {
        this(typeLabel);
        this.setAll(nutchMeta);
    }

    public void set(String key, String value) {
        if (key != null && value != null && key.length() > 0 && value.length() > 0) {
            this.m_metadata.set(key, value);
        }
    }

    public void add(String key, String value) {
        if (key != null && value != null && key.length() > 0 && value.length() > 0) {
            this.m_metadata.add(key, value);
        }
    }

    public void add(String key, String[] values) {
        if (key != null && values != null && key.length() > 0 && values.length > 0) {
            String[] stringArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                String val = stringArray[n2];
                if (val.length() > 0) {
                    this.m_metadata.add(key, val);
                }
                ++n2;
            }
        }
    }

    public void remove(String key) {
        this.m_metadata.remove(key);
    }

    public void clear() {
        this.m_metadata.clear();
    }

    public String[] get(String key) {
        String[] vals = this.m_metadata.getValues(key);
        return vals == null || vals.length == 0 ? null : vals;
    }

    public String getFirst(String key) {
        String[] vals = this.m_metadata.getValues(key);
        return vals == null || vals.length == 0 ? null : vals[0];
    }

    public void setAll(Metadata nutchMeta) {
        this.m_metadata.clear();
        String[] keys = nutchMeta.names();
        int i = 0;
        while (i < keys.length) {
            String[] vals = nutchMeta.getValues(keys[i]);
            int j = 0;
            while (j < vals.length) {
                this.m_metadata.add(keys[i], vals[j]);
                ++j;
            }
            ++i;
        }
    }

    public boolean hasKey(String key) {
        return this.m_metadata.get(key) != null;
    }

    public int numKeys() {
        return this.m_metadata.size();
    }

    public String[] keys() {
        return this.m_metadata.names();
    }

    public String toString() {
        StringBuilder strBld = new StringBuilder();
        strBld.append(this.m_typeLabel.length() > 0 ? String.valueOf(this.m_typeLabel) + " " : "");
        strBld.append("MetaData : ");
        strBld.append(this.m_metadata.toString());
        return strBld.toString();
    }

    public boolean equals(Object obj) {
        boolean same = obj instanceof MetaData;
        if (same) {
            MetaData other = (MetaData)obj;
            same = this.m_typeLabel.equals(other.m_typeLabel) && this.m_metadata.equals((Object)other.m_metadata);
        }
        return same;
    }

    @Override
    public void persist(XMLStreamWriter writer) throws XMLStreamException {
        String[] names;
        writer.writeStartElement(XML_TAG_METADATA);
        if (this.m_typeLabel.length() > 0) {
            writer.writeAttribute(XML_ATTRIB_TYPE, this.m_typeLabel.toString());
        }
        String[] stringArray = names = this.m_metadata.names();
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String[] vals;
            String name = stringArray[n2];
            String[] stringArray2 = vals = this.m_metadata.getValues(name);
            int n3 = vals.length;
            int n4 = 0;
            while (n4 < n3) {
                String val = stringArray2[n4];
                writer.writeStartElement(name);
                writer.writeCharacters(val);
                writer.writeEndElement();
                ++n4;
            }
            ++n2;
        }
        writer.writeEndElement();
    }

    @Override
    public void unpersist(XMLStreamReader reader) throws XMLStreamException {
        int event;
        this.m_typeLabel = reader.getAttributeValue(0);
        this.m_metadata.clear();
        while ((event = reader.next()) != 2 || !XML_TAG_METADATA.equals(reader.getName().toString())) {
            if (event != 1) continue;
            String elemTag = reader.getName().toString();
            String elemVal = reader.getElementText();
            this.add(elemTag, elemVal);
        }
    }

    public void readFields(DataInput in) throws IOException {
        this.m_typeLabel = Text.readString((DataInput)in);
        this.m_metadata.clear();
        this.m_metadata.readFields(in);
    }

    public void write(DataOutput out) throws IOException {
        Text.writeString((DataOutput)out, (String)this.m_typeLabel);
        this.m_metadata.write(out);
    }
}

