/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.number;

import babel.content.corpora.accessors.CorpusAccessor;
import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.PropertyCollector;
import babel.content.eqclasses.properties.number.Number;
import java.io.BufferedReader;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NumberCollector
extends PropertyCollector {
    public static final Log LOG = LogFactory.getLog(NumberCollector.class);

    public NumberCollector(boolean caseSensitive) throws Exception {
        super(caseSensitive);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void collectProperty(CorpusAccessor corpusAccess, Set<? extends EquivalenceClass> eqs) throws Exception {
        String curLine;
        BufferedReader reader = new BufferedReader(corpusAccess.getCorpusReader());
        HashMap<String, EquivalenceClass> eqsMap = new HashMap<String, EquivalenceClass>(eqs.size());
        for (EquivalenceClass equivalenceClass : eqs) {
            for (String word : equivalenceClass.getAllWords()) {
                assert (eqsMap.get(word) == null);
                eqsMap.put(word, equivalenceClass);
            }
        }
        while ((curLine = reader.readLine()) != null) {
            void var9_8;
            String[] curTokens = curLine.split("[\\|\\$\\*\\s\"'\\-\\+=,;:\u00ac\u00b4\u00ac\u00aa{}()<>\\[\\]\\.\\?\u00ac\u00f8!\u00ac\u00b0\u201a\u00c4\u00ec\u201a\u00c4\u00fa\u201a\u00c4\u00f9\u201a\u00c4\u00f2\u201a\u00c4\u00f4\u00ac\u2020]+");
            boolean bl = false;
            while (var9_8 < curTokens.length) {
                EquivalenceClass foundEq = (EquivalenceClass)eqsMap.get(EquivalenceClass.getWordOfAppropriateForm(curTokens[var9_8], this.m_caseSensitive));
                if (foundEq != null) {
                    Number tmpEqNumber = (Number)foundEq.getProperty(Number.class.getName());
                    if (tmpEqNumber == null) {
                        tmpEqNumber = new Number();
                        foundEq.setProperty(tmpEqNumber);
                    }
                    tmpEqNumber.increment();
                }
                ++var9_8;
            }
        }
        reader.close();
    }
}

