/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.lshorder;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.phrases.Phrase;
import babel.content.eqclasses.phrases.PhraseTable;
import babel.content.eqclasses.properties.LSHPropertyCollector;
import babel.content.eqclasses.properties.lshorder.LSHPhraseContext;
import babel.content.eqclasses.properties.order.PhraseContext;
import babel.content.eqclasses.properties.type.Type;
import babel.util.jerboa.LSH;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LSHPhraseContextCollector
extends LSHPropertyCollector {
    private static final Log LOG = LogFactory.getLog(LSHPhraseContextCollector.class);
    private static final LSH PHRASE_CONTEXT_LSH = new LSH();
    private static final byte[] EMPTY_SIG = PHRASE_CONTEXT_LSH.buildSignature(new HashMap<String, Double>());
    protected PhraseTable m_phraseDict;
    protected Random m_rand;

    public LSHPhraseContextCollector(boolean removeOrigProp, PhraseTable phTable) {
        super(removeOrigProp);
        this.m_phraseDict = phTable;
        this.m_rand = new Random();
    }

    @Override
    public void collectProperty(Set<? extends EquivalenceClass> eqClasses) throws Exception {
        int noPropCount = 0;
        for (EquivalenceClass equivalenceClass : eqClasses) {
            PhraseContext phContext = (PhraseContext)equivalenceClass.getProperty(PhraseContext.class.getName());
            Type.EqType type = ((Type)equivalenceClass.getProperty(Type.class.getName())).getType();
            if (Type.EqType.NONE.equals((Object)type)) {
                LOG.error((Object)"Cannot collect phrase context for a phrase without the Type property");
                throw new Exception("Cannot collect phrase context for a phrase without the Type property");
            }
            boolean src = Type.EqType.SOURCE.equals((Object)type);
            if (phContext != null) {
                equivalenceClass.setProperty(new LSHPhraseContext(equivalenceClass, this.getSignature(src, phContext.getBefore()), this.getSignature(src, phContext.getAfter()), this.getSignature(src, phContext.getDiscontinuous())));
                if (!this.m_removeOrigProp) continue;
                equivalenceClass.removeProperty(PhraseContext.class.getName());
                continue;
            }
            equivalenceClass.setProperty(new LSHPhraseContext(equivalenceClass, EMPTY_SIG, EMPTY_SIG, EMPTY_SIG));
            ++noPropCount;
        }
        LOG.info((Object)(" - " + noPropCount + " of " + eqClasses.size() + " phrases did not have PhraseContext property"));
    }

    protected byte[] getSignature(boolean src, Map<Phrase, Integer> phContext) {
        HashMap<String, Double> phCounts = new HashMap<String, Double>();
        for (Phrase contPhrase : phContext.keySet()) {
            int count = phContext.get(contPhrase);
            if (src) {
                for (Phrase contPhraseTrans : this.m_phraseDict.getTrgPhrases(contPhrase)) {
                    phCounts.put(Long.toString(contPhraseTrans.getId()), Double.valueOf(count));
                }
                continue;
            }
            phCounts.put(Long.toString(contPhrase.getId()), Double.valueOf(count));
        }
        return PHRASE_CONTEXT_LSH.buildSignature(phCounts);
    }

    protected Phrase getRandomPhrase(Set<Phrase> phrases) {
        Phrase p = null;
        if (!phrases.isEmpty()) {
            ArrayList<Phrase> phraseList = new ArrayList<Phrase>(phrases);
            p = phraseList.get(this.m_rand.nextInt(phraseList.size()));
        }
        return p;
    }
}

