/*
 * Decompiled with CFR 0.152.
 */
package babel.content.eqclasses.properties.context;

import babel.content.eqclasses.EquivalenceClass;
import babel.content.eqclasses.properties.Property;
import babel.content.eqclasses.properties.number.Number;
import babel.ranking.scorers.context.DictScorer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;

public class Context
extends Property {
    protected HashMap<Long, ContextualItem> m_neighborsMap;
    protected EquivalenceClass m_eq;
    protected boolean m_contItemsScored;
    protected HashMap<String, ContextualItem> m_collectedMap = null;

    public Context() {
        this(null);
    }

    public Context(EquivalenceClass eq) {
        this.m_eq = eq;
        this.m_neighborsMap = new HashMap();
        this.m_contItemsScored = false;
    }

    public int size() {
        return this.m_neighborsMap.size();
    }

    public EquivalenceClass getEq() {
        return this.m_eq;
    }

    public HashSet<Long> getContextualItemIds() {
        return new HashSet<Long>((Collection)this.m_neighborsMap.keySet());
    }

    public Collection<ContextualItem> getContextualItems() {
        return new ArrayList<ContextualItem>(this.m_neighborsMap.values());
    }

    public double getContextualItemScore(Long contItemId) {
        ContextualItem contItem = this.m_neighborsMap.get(contItemId);
        return contItem == null ? 0.0 : contItem.getScore();
    }

    public void clear() {
        this.m_neighborsMap.clear();
    }

    public ContextualItem getContextualItem(Long contItemId) {
        return this.m_neighborsMap.get(contItemId);
    }

    public void setContextualItem(ContextualItem contItem) {
        contItem.m_context = this;
        this.m_neighborsMap.put(contItem.m_contEqID, contItem);
    }

    public boolean areContItemsScored() {
        return this.m_contItemsScored;
    }

    public void contItemsScored() {
        this.m_contItemsScored = true;
    }

    void addContextWord(boolean caseSensitive, HashMap<String, EquivalenceClass> contextEqsMap, String contextWord) {
        EquivalenceClass contextEq = null;
        ContextualItem contextItem = null;
        String word = EquivalenceClass.getWordOfAppropriateForm(contextWord, caseSensitive);
        if (word != null && word.length() > 0) {
            if (this.m_collectedMap == null) {
                this.m_collectedMap = new HashMap();
            }
            try {
                contextItem = this.m_collectedMap.get(word);
                if (contextItem != null) {
                    contextItem.incContextCount();
                } else {
                    contextEq = contextEqsMap.get(word);
                    if (contextEq != null) {
                        contextItem = new ContextualItem(this, contextEq);
                        for (String contWord : contextEq.getAllWords()) {
                            this.m_collectedMap.put(contWord, contextItem);
                        }
                        this.m_neighborsMap.put(contextItem.getContextEqId(), contextItem);
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e.toString());
            }
        }
    }

    public void pruneContext(int numKeep, Comparator<ContextualItem> comparator) {
        if (this.m_neighborsMap != null && numKeep >= 0 && this.m_neighborsMap.size() > numKeep) {
            LinkedList<ContextualItem> valList = new LinkedList<ContextualItem>(this.m_neighborsMap.values());
            Collections.sort(valList, comparator);
            this.m_neighborsMap.clear();
            int i = 0;
            while (i < Math.min(valList.size(), numKeep)) {
                ContextualItem val = valList.get(i);
                this.m_neighborsMap.put(val.m_contEqID, val);
                ++i;
            }
        }
    }

    public ContextualItem lookup(Long contextEqId) {
        return this.m_neighborsMap == null ? null : this.m_neighborsMap.get(contextEqId);
    }

    public String toString() {
        return this.m_neighborsMap.values().toString();
    }

    @Override
    public String persistToString() {
        StringBuilder strBld = new StringBuilder();
        boolean first = true;
        for (Long key : this.m_neighborsMap.keySet()) {
            if (first) {
                first = false;
            } else {
                strBld.append("\t");
            }
            strBld.append(this.m_neighborsMap.get(key).persistToString());
        }
        return strBld.toString();
    }

    @Override
    public void unpersistFromString(EquivalenceClass eq, String str) throws Exception {
        this.m_eq = eq;
        this.m_neighborsMap.clear();
        this.m_contItemsScored = false;
        if (!str.isEmpty()) {
            String[] toks = str.split("\t");
            int i = 0;
            while (i < toks.length) {
                ContextualItem cItem = ContextualItem.unpersistFromString(this, toks[i]);
                this.m_neighborsMap.put(cItem.getContextEqId(), cItem);
                ++i;
            }
        }
    }

    public static class ContextualItem {
        protected Context m_context;
        protected long m_contCount;
        protected long m_corpCount;
        protected double m_score;
        protected Long m_contEqID;

        private ContextualItem(Context context) {
            this.m_context = context;
            this.m_contCount = 0L;
            this.m_corpCount = 0L;
            this.m_score = 0.0;
        }

        public ContextualItem(Context context, EquivalenceClass contextEq) {
            this(context, contextEq.getId(), ((Number)contextEq.getProperty(Number.class.getName())).getNumber(), 1L);
        }

        public ContextualItem(Context context, Long contEqId, long corpusCount, long contextCount) {
            this.m_contEqID = contEqId;
            this.m_context = context;
            this.m_corpCount = corpusCount;
            this.m_contCount = contextCount;
            this.m_score = 0.0;
        }

        public int hashCode() {
            return this.m_contEqID.hashCode();
        }

        public void incContextCount() {
            ++this.m_contCount;
        }

        public long getContextCount() {
            return this.m_contCount;
        }

        public long getCorpusCount() {
            return this.m_corpCount;
        }

        public Context getContext() {
            return this.m_context;
        }

        public void setScore(double score) {
            this.m_score = score;
        }

        public double getScore() {
            return this.m_score;
        }

        public Long getContextEqId() {
            return this.m_contEqID;
        }

        public String toString() {
            return this.persistToString();
        }

        protected String persistToString() {
            StringBuilder strBld = new StringBuilder();
            strBld.append(this.m_contEqID);
            strBld.append("(");
            strBld.append(this.m_contCount);
            strBld.append(" ");
            strBld.append(this.m_corpCount);
            strBld.append(")");
            return strBld.toString();
        }

        public static ContextualItem unpersistFromString(Context context, String str) throws Exception {
            ContextualItem ci = new ContextualItem(context);
            String[] toks = str.split("[( )]");
            ci.m_contEqID = Long.parseLong(toks[0]);
            ci.m_contCount = Long.parseLong(toks[1]);
            ci.m_corpCount = Long.parseLong(toks[2]);
            return ci;
        }
    }

    public static class CountComparator
    implements Comparator<ContextualItem> {
        @Override
        public int compare(ContextualItem item1, ContextualItem item2) {
            long diff = item2.getContextCount() - item1.getContextCount();
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
    }

    public static class ScoreComparator
    implements Comparator<ContextualItem> {
        protected DictScorer m_scorer;

        public ScoreComparator(DictScorer scorer) {
            this.m_scorer = scorer;
        }

        @Override
        public int compare(ContextualItem item1, ContextualItem item2) {
            int direction;
            item1.getScore();
            double score1 = item1.getScore();
            double score2 = item2.getScore();
            int n = direction = this.m_scorer.smallerScoresAreBetter() ? -1 : 1;
            return score1 == score2 ? 0 : direction * (score2 > score1 ? 1 : -1);
        }
    }
}

