/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.planar3T;

import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.syntaxgraph.DependencyStructure;
import org.maltparser.core.syntaxgraph.edge.Edge;
import org.maltparser.core.syntaxgraph.node.DependencyNode;
import org.maltparser.core.syntaxgraph.node.TokenNode;
import org.maltparser.parser.DependencyParserConfig;
import org.maltparser.parser.Oracle;
import org.maltparser.parser.ParserConfiguration;
import org.maltparser.parser.algorithm.planar3T.Planar3TConfig;
import org.maltparser.parser.history.GuideUserHistory;
import org.maltparser.parser.history.action.GuideUserAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Planar3TArcEagerOracle
extends Oracle {
    public Planar3TArcEagerOracle(DependencyParserConfig manager, GuideUserHistory history) throws MaltChainedException {
        super(manager, history);
        this.setGuideName("Planar3T");
    }

    @Override
    public GuideUserAction predict(DependencyStructure gold, ParserConfiguration config) throws MaltChainedException {
        int inputPeekIndex;
        Planar3TConfig planarConfig = (Planar3TConfig)config;
        DependencyStructure dg = planarConfig.getDependencyGraph();
        DependencyNode stackPeek = planarConfig.getStack().peek();
        int stackPeekIndex = stackPeek.getIndex();
        if (this.checkIfNodesAreRelated(gold, stackPeekIndex, inputPeekIndex = planarConfig.getInput().peek().getIndex()) && !this.checkIfNodesAreRelated(dg, stackPeekIndex, inputPeekIndex)) {
            return this.updateActionContainers(3, this.getEdgeGraph(gold, stackPeekIndex, inputPeekIndex).getLabelSet());
        }
        if (planarConfig.getRootHandling() == 1 && !stackPeek.hasHead()) {
            return this.updateActionContainers(1, null);
        }
        if (this.areInputBufferRelated(gold, planarConfig.getStack(), inputPeekIndex) && (!this.checkIfNodesAreRelated(gold, 0, inputPeekIndex) || planarConfig.getRootHandling() == 3)) {
            return this.updateActionContainers(2, null);
        }
        return this.updateActionContainers(1, null);
    }

    private boolean checkIfNodesAreRelated(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        TokenNode tk = dg.getTokenNode(index1);
        Set<DependencyNode> heads = null;
        if (tk != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index2) continue;
                return true;
            }
        }
        if ((tk = dg.getTokenNode(index2)) != null) {
            heads = tk.getHeads();
            for (DependencyNode head : heads) {
                if (head.getIndex() != index1) continue;
                return true;
            }
        }
        return false;
    }

    private boolean areInputBufferRelated(DependencyStructure dg, Stack<DependencyNode> stack, int indexBuffer) throws MaltChainedException {
        for (DependencyNode nodo : stack) {
            if (!this.checkIfNodesAreRelated(dg, nodo.getIndex(), indexBuffer) || stack.peek().getIndex() == nodo.getIndex()) continue;
            return true;
        }
        return false;
    }

    private Edge getEdgeGraph(DependencyStructure dg, int index1, int index2) throws MaltChainedException {
        SortedSet<Edge> arcos = dg.getEdges();
        for (Edge arco : arcos) {
            if (arco.getSource().getIndex() == index1 && arco.getTarget().getIndex() == index2) {
                return arco;
            }
            if (arco.getSource().getIndex() != index2 || arco.getTarget().getIndex() != index1) continue;
            return arco;
        }
        return null;
    }

    @Override
    public void finalizeSentence(DependencyStructure dependencyGraph) throws MaltChainedException {
    }

    @Override
    public void terminate() throws MaltChainedException {
    }
}

