package szte.io;

import java.io.BufferedWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class CMCDocument implements Document {
		
		public static HashMap<String, Integer> major_Annotations = new HashMap<String, Integer>();
		
		protected HashSet<String> major_Annotation; 
		
		protected String history; 
		protected String impression;
		protected String docid;
		
	  public CMCDocument()
	  {
			major_Annotation = new HashSet<String>();
			history = "";
			impression = "";
			docid = "";
		}

	  public void addMajorAnnotation(String ma) {
			major_Annotation.add(ma);
		}

		public void setHistory(String h) {
			history = h;
		}
		
		public void setImpression(String i) {
			impression = i;
		}

		public void setDocID(String id) {
			docid = id;
		}

		public Set<String> getLabels() {
			return major_Annotation;
		}

    public String getText(){
      return history + "\n" + impression;
    }

     public String getImpression() {
				return impression;
			}

		  public String getHistory() {
				return history;
			}

			public String getDocID() {
				return docid;
			}
			
			public String toString() {
				String ret = "";
				ret += "docid: " + docid + "\n";
				ret += "major_Annotation: " + major_Annotation + "\n";
				ret += "history: " + history + "\n";
				ret += "impression: " + impression + "\n";
				return ret;
			}

		  public void wirteXML(BufferedWriter w, Collection<String> pred) throws Exception
		  {
			  w.write("<doc id=\"" + docid + "\" type=\"RADIOLOGY_REPORT\">");w.newLine();
		    w.write("<codes>"); w.newLine();
		    for(String label : pred)
		    {w.write("<code origin=\"CMC_MAJORITY\" type=\"ICD-9-CM\">" + label + "</code>");w.newLine();}
		    w.write("</codes>"); w.newLine();
		    w.write("<texts>"); w.newLine();
		    w.write("<text origin=\"CCHMC_RADIOLOGY\" type=\"CLINICAL_HISTORY\">");
		    w.write(history + "</text> "); w.newLine();
		    w.write("<text origin=\"CCHMC_RADIOLOGY\" type=\"IMPRESSION\">");
		    w.write(impression + "</text> "); w.newLine();
		    w.write("</texts>"); w.newLine();
		    w.write("</doc>"); w.newLine();
		  }
}
