#!/bin/bash

ckpt_path=$1
echo $ckpt_path

CUDA=$2
echo $CUDA

export CUDA_VISIBLE_DEVICES=$CUDA

timestamp=$3



# environment 
export VLLM_USE_MODELSCOPE="False"
export TOKENIZERS_PARALLELISM=false

debug_num=-1

save_dir=path_to_output

dataname_list=(
    math
    gsm8k
    gaokao
    ocw
)


python=path_to_python

for dataname in "${dataname_list[@]}"
do
    question_path=path_to_dataset/${dataname}_test.jsonl
    $python ../mario/batch_react_inference.py \
    --question_file $question_path \
    --checkpoint_dir $ckpt_path \
    --save_dir $save_dir \
    --debug_num $debug_num > ./logs/$(basename ${ckpt_path})_${dataname}_${timestamp}.log 2>&1
    wait
done