import os
from openai import OpenAI

class Prompter:
    def __init__(self):
        self.client = OpenAI(
            api_key = os.environ.get("OPENAI_API_KEY"),
        )

    def _run_prompt(self, messages, temp=0):
        response = self.client.chat.completions.create(
            messages = messages,
            model="gpt-4-turbo",
            temperature=temp,
            max_tokens=1024,
        )
        return response

    def prompt(self, text, entity):
        initial_content = f"You are a helpful assistant."
        
        prompt = [{"role": "system", "content": initial_content}]

        # str_list = repr(mention_list)

        content = (
            f"Generate a Q&A pair about [{entity}] based on a given context. The context will provide factual information about [{entity}].\n"
            f"Assume the person answering the question has common sense and is aware of the details and key points in the context, but the context itself is not quoted or referenced directly.\n\n"
            f"Context: {text}\n\n"
            f"Follow these instructions to generate a Q&A pair:\n"
            f" 1) Provide a question and an answer.\n"
            f" 2) Bracket the corresponding Entity ([{entity}]) in the Question, like the sample Q&A pair given below.\n"
            f" 3) Do NOT use phrases such as ‘according to the context’ in your question.\n"
            f" 4) Generate a SINGLE Q&A pair.\n"
            f" 5) Provide a SHORT ANSWER.\n\n"
            "Write your Q&A pair within curly brackets using the following format: {Question}{Answer}\n\n"
            "Sample Q&A pair : {Where was [Lionel_Messi] born?}{Lionel Messi was born in Rosario, Argentina.}"
        )

        print(content)
        prompt.extend([{"role": "user", "content": content}])

        response = self._run_prompt(prompt)
        res = response.choices[0].message.content
        print(res)
        return res
    
if __name__ == "__main__":
    prompter = Prompter()
    prompter.prompt("Mohamed Salah is 29 years old", "Mohamed_Salah")