/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.tagger.maxent;

import edu.stanford.nlp.io.EncodingPrintWriter;
import edu.stanford.nlp.io.PrintFile;
import edu.stanford.nlp.ling.HasOffset;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Sentence;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.math.ArrayMath;
import edu.stanford.nlp.math.SloppyMath;
import edu.stanford.nlp.sequences.ExactBestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.tagger.maxent.Extractor;
import edu.stanford.nlp.tagger.maxent.ExtractorFrames;
import edu.stanford.nlp.tagger.maxent.Extractors;
import edu.stanford.nlp.tagger.maxent.History;
import edu.stanford.nlp.tagger.maxent.MaxentTagger;
import edu.stanford.nlp.tagger.maxent.PairsHolder;
import edu.stanford.nlp.tagger.maxent.TaggerConfig;
import edu.stanford.nlp.util.ArrayUtils;
import edu.stanford.nlp.util.ConfusionMatrix;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TestSentence
implements SequenceModel {
    protected final boolean VERBOSE;
    protected static final String naTag = "NA";
    private static final String[] naTagArr = new String[]{"NA"};
    protected static final boolean DBG = false;
    protected static final int kBestSize = 1;
    protected final String tagSeparator;
    protected final String encoding;
    protected final PairsHolder pairs = new PairsHolder();
    protected List<String> sent;
    protected List<String> originalTags;
    protected List<HasWord> origWords;
    protected int size;
    protected String[] correctTags;
    protected String[] finalTags;
    ArrayList<TaggedWord> result;
    int numRight;
    int numWrong;
    int numUnknown;
    int numWrongUnknown;
    private int endSizePairs;
    private volatile History history;
    protected volatile Map<String, double[]> localScores = Generics.newHashMap();
    protected volatile double[][] localContextScores;
    protected final MaxentTagger maxentTagger;

    public TestSentence(MaxentTagger maxentTagger) {
        assert (maxentTagger != null);
        assert (maxentTagger.getLambdaSolve() != null);
        this.maxentTagger = maxentTagger;
        if (maxentTagger.config != null) {
            this.tagSeparator = maxentTagger.config.getTagSeparator();
            this.encoding = maxentTagger.config.getEncoding();
            this.VERBOSE = maxentTagger.config.getVerbose();
        } else {
            this.tagSeparator = TaggerConfig.getDefaultTagSeparator();
            this.encoding = "utf-8";
            this.VERBOSE = false;
        }
        this.history = new History(this.pairs, maxentTagger.extractors);
    }

    public void setCorrectTags(List<? extends HasTag> sentence) {
        int len = sentence.size();
        this.correctTags = new String[len];
        for (int i = 0; i < len; ++i) {
            this.correctTags[i] = sentence.get(i).tag();
        }
    }

    public ArrayList<TaggedWord> tagSentence(List<? extends HasWord> s, boolean reuseTags) {
        int j;
        this.origWords = new ArrayList<HasWord>(s);
        int sz = s.size();
        this.sent = new ArrayList<String>(sz + 1);
        for (j = 0; j < sz; ++j) {
            if (this.maxentTagger.wordFunction != null) {
                this.sent.add(this.maxentTagger.wordFunction.apply(s.get(j).word()));
                continue;
            }
            this.sent.add(s.get(j).word());
        }
        this.sent.add(".$.");
        if (reuseTags) {
            this.originalTags = new ArrayList<String>(sz + 1);
            for (j = 0; j < sz; ++j) {
                if (s.get(j) instanceof HasTag) {
                    this.originalTags.add(((HasTag)((Object)s.get(j))).tag());
                    continue;
                }
                this.originalTags.add(null);
            }
            this.originalTags.add(".$$.");
        }
        this.size = sz + 1;
        if (this.VERBOSE) {
            System.err.println("Sentence is " + Sentence.listToString(this.sent, false, this.tagSeparator));
        }
        this.init();
        this.result = this.testTagInference();
        if (this.maxentTagger.wordFunction != null) {
            for (j = 0; j < sz; ++j) {
                this.result.get(j).setWord(s.get(j).word());
            }
        }
        return this.result;
    }

    protected void revert(int prevSize) {
        this.endSizePairs = prevSize;
    }

    protected void init() {
        this.localContextScores = new double[this.size][];
        for (int i = 0; i < this.size - 1; ++i) {
            if (!this.maxentTagger.dict.isUnknown(this.sent.get(i))) continue;
            ++this.numUnknown;
        }
    }

    String getTaggedNice() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.size - 1; ++i) {
            sb.append(TestSentence.toNice(this.sent.get(i))).append(this.tagSeparator).append(TestSentence.toNice(this.finalTags[i]));
            sb.append(' ');
        }
        return sb.toString();
    }

    ArrayList<TaggedWord> getTaggedSentence() {
        boolean hasOffset = this.origWords != null && this.origWords.size() > 0 && this.origWords.get(0) instanceof HasOffset;
        ArrayList<TaggedWord> taggedSentence = new ArrayList<TaggedWord>();
        for (int j = 0; j < this.size - 1; ++j) {
            String tag = this.finalTags[j];
            TaggedWord w = new TaggedWord(this.sent.get(j), tag);
            if (hasOffset) {
                HasOffset offset = (HasOffset)((Object)this.origWords.get(j));
                w.setBeginPosition(offset.beginPosition());
                w.setEndPosition(offset.endPosition());
            }
            taggedSentence.add(w);
        }
        return taggedSentence;
    }

    static String toNice(String s) {
        if (s == null) {
            return naTag;
        }
        return s;
    }

    protected void calculateProbs(double[][][] probabilities) {
        ArrayUtils.fill(probabilities, Double.NEGATIVE_INFINITY);
        for (int hyp = 0; hyp < 1; ++hyp) {
            this.pairs.setSize(this.size);
            for (int i = 0; i < this.size; ++i) {
                this.pairs.setWord(i, this.sent.get(i));
                this.pairs.setTag(i, this.finalTags[i]);
            }
            int start = this.endSizePairs;
            int end = this.endSizePairs + this.size - 1;
            this.endSizePairs += this.size;
            for (int current = 0; current < this.size; ++current) {
                History h = new History(start, end, current + start, this.pairs, this.maxentTagger.extractors);
                String[] tags = this.stringTagsAt(h.current - h.start + this.leftWindow());
                double[] probs = this.getHistories(tags, h);
                ArrayMath.logNormalize(probs);
                for (int j = 0; j < tags.length; ++j) {
                    String tag = tags[j];
                    boolean approximate = this.maxentTagger.hasApproximateScoring();
                    int tagindex = approximate ? this.maxentTagger.tags.getIndex(tag) : j;
                    probabilities[current][hyp][tagindex] = probs[j];
                }
            }
        }
        this.revert(0);
    }

    protected void writeTagsAndErrors(String[] finalTags, PrintFile pf, boolean verboseResults) {
        StringWriter sw = new StringWriter(200);
        for (int i = 0; i < this.correctTags.length; ++i) {
            sw.write(TestSentence.toNice(this.sent.get(i)));
            sw.write(this.tagSeparator);
            sw.write(finalTags[i]);
            sw.write(32);
            if (pf != null) {
                pf.print(TestSentence.toNice(this.sent.get(i)));
                pf.print(this.tagSeparator);
                pf.print(finalTags[i]);
            }
            if (this.correctTags[i].equals(finalTags[i])) {
                ++this.numRight;
            } else {
                ++this.numWrong;
                if (pf != null) {
                    pf.print('|' + this.correctTags[i]);
                }
                if (verboseResults) {
                    EncodingPrintWriter.err.println((this.maxentTagger.dict.isUnknown(this.sent.get(i)) ? "Unk" : "") + "Word: " + this.sent.get(i) + "; correct: " + this.correctTags[i] + "; guessed: " + finalTags[i], this.encoding);
                }
                if (this.maxentTagger.dict.isUnknown(this.sent.get(i))) {
                    ++this.numWrongUnknown;
                    if (pf != null) {
                        pf.print("*");
                    }
                }
            }
            if (pf == null) continue;
            pf.print(' ');
        }
        if (pf != null) {
            pf.println();
        }
        if (verboseResults) {
            PrintWriter pw;
            try {
                pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)System.out, this.encoding), true);
            }
            catch (UnsupportedEncodingException uee) {
                pw = new PrintWriter((Writer)new OutputStreamWriter(System.out), true);
            }
            pw.println(sw);
        }
    }

    protected void updateConfusionMatrix(String[] finalTags, ConfusionMatrix<String> confusionMatrix) {
        for (int i = 0; i < this.correctTags.length; ++i) {
            confusionMatrix.add(finalTags[i], this.correctTags[i]);
        }
    }

    private ArrayList<TaggedWord> testTagInference() {
        this.runTagInference();
        return this.getTaggedSentence();
    }

    private void runTagInference() {
        this.initializeScorer();
        ExactBestSequenceFinder ti = new ExactBestSequenceFinder();
        int[] bestTags = ti.bestSequence(this);
        this.finalTags = new String[bestTags.length];
        for (int j = 0; j < this.size; ++j) {
            this.finalTags[j] = this.maxentTagger.tags.getTag(bestTags[j + this.leftWindow()]);
        }
        this.cleanUpScorer();
    }

    private void setHistory(int current, History h, int[] tags) {
        int left = this.leftWindow();
        int right = this.rightWindow();
        for (int j = current - left; j <= current + right; ++j) {
            if (j < left) continue;
            if (j >= this.size + left) break;
            h.setTag(j - left, this.maxentTagger.tags.getTag(tags[j]));
        }
    }

    protected void initializeScorer() {
        this.pairs.setSize(this.size);
        for (int i = 0; i < this.size; ++i) {
            this.pairs.setWord(i, this.sent.get(i));
        }
        this.endSizePairs += this.size;
    }

    protected void cleanUpScorer() {
        this.revert(0);
    }

    private double[] getScores(History h) {
        if (this.maxentTagger.hasApproximateScoring()) {
            return this.getApproximateScores(h);
        }
        return this.getExactScores(h);
    }

    private double[] getExactScores(History h) {
        String[] tags = this.stringTagsAt(h.current - h.start + this.leftWindow());
        double[] histories = this.getHistories(tags, h);
        ArrayMath.logNormalize(histories);
        double[] scores = new double[tags.length];
        for (int j = 0; j < tags.length; ++j) {
            String tag = tags[j];
            int tagindex = this.maxentTagger.tags.getIndex(tag);
            scores[j] = histories[tagindex];
        }
        return scores;
    }

    private double[] getApproximateScores(History h) {
        String[] tags = this.stringTagsAt(h.current - h.start + this.leftWindow());
        double[] scores = this.getHistories(tags, h);
        int nDefault = this.maxentTagger.ySize - tags.length;
        double logScore = ArrayMath.logSum(scores);
        double logScoreInactiveTags = this.maxentTagger.getInactiveTagDefaultScore(nDefault);
        double logTotal = SloppyMath.logAdd(logScore, logScoreInactiveTags);
        ArrayMath.addInPlace(scores, -logTotal);
        return scores;
    }

    protected double[] getHistories(String[] tags, History h) {
        boolean rare = this.maxentTagger.isRare(ExtractorFrames.cWord.extract(h));
        Extractors ex = this.maxentTagger.extractors;
        Extractors exR = this.maxentTagger.extractorsRare;
        String w = this.pairs.getWord(h.current);
        double[] lS = this.localScores.get(w);
        if (lS == null) {
            lS = this.getHistories(tags, h, ex.local, rare ? exR.local : null);
            this.localScores.put(w, lS);
        } else if (lS.length != tags.length) {
            lS = this.getHistories(tags, h, ex.local, rare ? exR.local : null);
            if (tags.length > 1) {
                this.localScores.put(w, lS);
            }
        }
        double[] lcS = this.localContextScores[h.current];
        if (lcS == null) {
            lcS = this.getHistories(tags, h, ex.localContext, rare ? exR.localContext : null);
            this.localContextScores[h.current] = lcS;
            ArrayMath.pairwiseAddInPlace(lcS, lS);
        }
        double[] totalS = this.getHistories(tags, h, ex.dynamic, rare ? exR.dynamic : null);
        ArrayMath.pairwiseAddInPlace(totalS, lcS);
        return totalS;
    }

    private double[] getHistories(String[] tags, History h, List<Pair<Integer, Extractor>> extractors, List<Pair<Integer, Extractor>> extractorsRare) {
        if (this.maxentTagger.hasApproximateScoring()) {
            return this.getApproximateHistories(tags, h, extractors, extractorsRare);
        }
        return this.getExactHistories(h, extractors, extractorsRare);
    }

    private double[] getExactHistories(History h, List<Pair<Integer, Extractor>> extractors, List<Pair<Integer, Extractor>> extractorsRare) {
        int fNum;
        int i;
        int[] fAssociations;
        String val;
        Extractor ex;
        int kf;
        double[] scores = new double[this.maxentTagger.ySize];
        int szCommon = this.maxentTagger.extractors.size();
        for (Pair<Integer, Extractor> e : extractors) {
            kf = e.first();
            ex = e.second();
            val = ex.extract(h);
            fAssociations = this.maxentTagger.fAssociations.get(kf).get(val);
            if (fAssociations == null) continue;
            for (i = 0; i < this.maxentTagger.ySize; ++i) {
                fNum = fAssociations[i];
                if (fNum <= -1) continue;
                int n = i;
                scores[n] = scores[n] + this.maxentTagger.getLambdaSolve().lambda[fNum];
            }
        }
        if (extractorsRare != null) {
            for (Pair<Integer, Extractor> e : extractorsRare) {
                kf = e.first();
                ex = e.second();
                val = ex.extract(h);
                fAssociations = this.maxentTagger.fAssociations.get(kf + szCommon).get(val);
                if (fAssociations == null) continue;
                for (i = 0; i < this.maxentTagger.ySize; ++i) {
                    fNum = fAssociations[i];
                    if (fNum <= -1) continue;
                    int n = i;
                    scores[n] = scores[n] + this.maxentTagger.getLambdaSolve().lambda[fNum];
                }
            }
        }
        return scores;
    }

    private double[] getApproximateHistories(String[] tags, History h, List<Pair<Integer, Extractor>> extractors, List<Pair<Integer, Extractor>> extractorsRare) {
        int fNum;
        int tagIndex;
        String tag;
        int j;
        int[] fAssociations;
        String val;
        Extractor ex;
        int kf;
        double[] scores = new double[tags.length];
        int szCommon = this.maxentTagger.extractors.size();
        for (Pair<Integer, Extractor> e : extractors) {
            kf = e.first();
            ex = e.second();
            val = ex.extract(h);
            fAssociations = this.maxentTagger.fAssociations.get(kf).get(val);
            if (fAssociations == null) continue;
            for (j = 0; j < tags.length; ++j) {
                tag = tags[j];
                tagIndex = this.maxentTagger.tags.getIndex(tag);
                fNum = fAssociations[tagIndex];
                if (fNum <= -1) continue;
                int n = j;
                scores[n] = scores[n] + this.maxentTagger.getLambdaSolve().lambda[fNum];
            }
        }
        if (extractorsRare != null) {
            for (Pair<Integer, Extractor> e : extractorsRare) {
                kf = e.first();
                ex = e.second();
                val = ex.extract(h);
                fAssociations = this.maxentTagger.fAssociations.get(szCommon + kf).get(val);
                if (fAssociations == null) continue;
                for (j = 0; j < tags.length; ++j) {
                    tag = tags[j];
                    tagIndex = this.maxentTagger.tags.getIndex(tag);
                    fNum = fAssociations[tagIndex];
                    if (fNum <= -1) continue;
                    int n = j;
                    scores[n] = scores[n] + this.maxentTagger.getLambdaSolve().lambda[fNum];
                }
            }
        }
        return scores;
    }

    void printUnknown(int numSent, PrintFile pfu) {
        DecimalFormat nf = new DecimalFormat("0.0000");
        int numTags = this.maxentTagger.numTags();
        double[][][] probabilities = new double[this.size][1][numTags];
        this.calculateProbs(probabilities);
        for (int current = 0; current < this.size; ++current) {
            int rank;
            if (!this.maxentTagger.dict.isUnknown(this.sent.get(current))) continue;
            pfu.print(this.sent.get(current));
            pfu.print(':');
            pfu.print(numSent);
            double[] probs = new double[3];
            String[] tag3 = new String[3];
            this.getTop3(probabilities, current, probs, tag3);
            for (int i = 0; i < 3; ++i) {
                if (!(probs[i] > Double.NEGATIVE_INFINITY)) continue;
                pfu.print('\t');
                pfu.print(tag3[i]);
                pfu.print(' ');
                pfu.print(nf.format(Math.exp(probs[i])));
            }
            String correctTag = TestSentence.toNice(this.correctTags[current]);
            for (rank = 0; rank < 3 && !correctTag.equals(tag3[rank]); ++rank) {
            }
            pfu.print('\t');
            switch (rank) {
                case 0: {
                    pfu.print("Correct");
                    break;
                }
                case 1: {
                    pfu.print("2nd");
                    break;
                }
                case 2: {
                    pfu.print("3rd");
                    break;
                }
                default: {
                    pfu.print("Not top 3");
                }
            }
            pfu.println();
        }
    }

    void printTop(PrintFile pfu) {
        DecimalFormat nf = new DecimalFormat("0.0000");
        int numTags = this.maxentTagger.numTags();
        double[][][] probabilities = new double[this.size][1][numTags];
        this.calculateProbs(probabilities);
        for (int current = 0; current < this.correctTags.length; ++current) {
            int rank;
            pfu.print(this.sent.get(current));
            double[] probs = new double[3];
            String[] tag3 = new String[3];
            this.getTop3(probabilities, current, probs, tag3);
            for (int i = 0; i < 3; ++i) {
                if (!(probs[i] > Double.NEGATIVE_INFINITY)) continue;
                pfu.print('\t');
                pfu.print(tag3[i]);
                pfu.print(' ');
                pfu.print(nf.format(Math.exp(probs[i])));
            }
            String correctTag = TestSentence.toNice(this.correctTags[current]);
            for (rank = 0; rank < 3 && !correctTag.equals(tag3[rank]); ++rank) {
            }
            pfu.print('\t');
            switch (rank) {
                case 0: {
                    pfu.print("Correct");
                    break;
                }
                case 1: {
                    pfu.print("2nd");
                    break;
                }
                case 2: {
                    pfu.print("3rd");
                    break;
                }
                default: {
                    pfu.print("Not top 3");
                }
            }
            pfu.println();
        }
    }

    private void getTop3(double[][][] probabilities, int current, double[] probs, String[] tags) {
        int[] topIds = new int[3];
        double[] probTags = probabilities[current][0];
        Arrays.fill(probs, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < probTags.length; ++i) {
            if (probTags[i] > probs[0]) {
                probs[2] = probs[1];
                probs[1] = probs[0];
                probs[0] = probTags[i];
                topIds[2] = topIds[1];
                topIds[1] = topIds[0];
                topIds[0] = i;
                continue;
            }
            if (probTags[i] > probs[1]) {
                probs[2] = probs[1];
                probs[1] = probTags[i];
                topIds[2] = topIds[1];
                topIds[1] = i;
                continue;
            }
            if (!(probTags[i] > probs[2])) continue;
            probs[2] = probTags[i];
            topIds[2] = i;
        }
        for (int j = 0; j < 3; ++j) {
            tags[j] = TestSentence.toNice(this.maxentTagger.tags.getTag(topIds[j]));
        }
    }

    @Override
    public int length() {
        return this.sent.size();
    }

    @Override
    public int leftWindow() {
        return this.maxentTagger.leftContext;
    }

    @Override
    public int rightWindow() {
        return this.maxentTagger.rightContext;
    }

    @Override
    public int[] getPossibleValues(int pos) {
        String[] arr1 = this.stringTagsAt(pos);
        int[] arr = new int[arr1.length];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = this.maxentTagger.tags.getIndex(arr1[i]);
        }
        return arr;
    }

    @Override
    public double scoreOf(int[] tags, int pos) {
        double[] scores = this.scoresOf(tags, pos);
        double score = Double.NEGATIVE_INFINITY;
        int[] pv = this.getPossibleValues(pos);
        for (int i = 0; i < scores.length; ++i) {
            if (pv[i] != tags[pos]) continue;
            score = scores[i];
        }
        return score;
    }

    @Override
    public double scoreOf(int[] sequence) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double[] scoresOf(int[] tags, int pos) {
        this.history.init(this.endSizePairs - this.size, this.endSizePairs - 1, this.endSizePairs - this.size + pos - this.leftWindow());
        this.setHistory(pos, this.history, tags);
        return this.getScores(this.history);
    }

    protected String[] stringTagsAt(int pos) {
        String[] arr1;
        if (pos < this.leftWindow() || pos >= this.size + this.leftWindow()) {
            return naTagArr;
        }
        if (this.originalTags != null && this.originalTags.get(pos - this.leftWindow()) != null) {
            String[] arr12 = new String[]{this.originalTags.get(pos - this.leftWindow())};
            return arr12;
        }
        String word = this.sent.get(pos - this.leftWindow());
        if (this.maxentTagger.dict.isUnknown(word)) {
            Set<String> open = this.maxentTagger.tags.getOpenTags();
            arr1 = open.toArray(new String[open.size()]);
        } else {
            arr1 = this.maxentTagger.dict.getTags(word);
        }
        arr1 = this.maxentTagger.tags.deterministicallyExpandTags(arr1);
        return arr1;
    }
}

