theory question_23_8

imports Main

begin

typedecl entity
typedecl event

consts
  Hurricane :: "entity ⇒ bool"
  Tornado :: "entity ⇒ bool"
  HighWind :: "event ⇒ bool"
  Has :: "entity ⇒ event ⇒ bool"
  Entity :: "entity ⇒ bool"

(* Explanation 1: Every hurricane is an entity that has high wind speeds. *)
axiomatization where
  explanation_1: "∀x. Hurricane x ⟹ (∃e. HighWind e ∧ Has x e)"

(* Explanation 2: Every tornado is an entity that has high wind speeds. *)
axiomatization where
  explanation_2: "∀x. Tornado x ⟹ (∃e. HighWind e ∧ Has x e)"

(* Explanation 3: Both hurricanes and tornadoes are entities. *)
axiomatization where
  explanation_3: "∀x. (Hurricane x ∨ Tornado x) ⟹ Entity x"

theorem hypothesis:
  assumes asm: "Hurricane x ∨ Tornado x"
  (* Hypothesis: Both hurricanes and tornadoes always have high winds. *)
  shows "∃e. HighWind e ∧ Has x e"
proof -
  assume asm: "Hurricane x ∨ Tornado x"
  thus "∃e. HighWind e ∧ Has x e"
  proof (cases "Hurricane x")
    case True
    then obtain e where "HighWind e ∧ Has x e" by (rule explanation_1)
    thus ?thesis by blast
  next
    case False
    then obtain e where "HighWind e ∧ Has x e" by (rule explanation_2)
    thus ?thesis by blast
  qed

end
