theory question_71_5

imports Main

begin

typedecl entity

consts
  Chlorophyll :: "entity ⇒ bool"
  Chloroplasts :: "entity ⇒ bool"
  Animals :: "entity ⇒ bool"

(* Explanation 1: Chloroplasts are the only entities that contain chlorophyll. *)
axiomatization where
  explanation_1: "∀x. Chlorophyll x ⟷ Chloroplasts x"

(* Explanation 2: Animals do not possess chloroplasts. *)
axiomatization where
  explanation_2: "∀x. Animals x ⟶ ¬Chloroplasts x"

(* Explanation 3: If an entity does not possess chloroplasts, it does not contain chlorophyll. *)
axiomatization where
  explanation_3: "∀x. ¬Chloroplasts x ⟶ ¬Chlorophyll x"

(* Explanation 4: If an entity does not contain chlorophyll, it does not have chlorophyll. *)
axiomatization where
  explanation_4: "∀x. ¬Chlorophyll x ⟶ ¬Chlorophyll x"

theorem hypothesis:
  assumes asm: "Animals x"
  (* Hypothesis: Animals lack chlorophyll. *)
  shows "¬Chlorophyll x"
proof -
  from asm have "Animals x" by simp
  then have "¬Chloroplasts x" using explanation_2 by blast
  then have "¬Chlorophyll x" using explanation_3 by blast
  show ?thesis using asm `Chlorophyll x` by blast
qed

end
